/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.screens.editor;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.control.Input;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.editorTools.Brush;
import group24.escaperoom.ui.editorTools.DeletionTool;
import group24.escaperoom.ui.editorTools.EditorTool;
import group24.escaperoom.ui.editorTools.EyeDropTool;
import group24.escaperoom.ui.editorTools.FillTool;
import group24.escaperoom.ui.editorTools.ItemDrawer;
import group24.escaperoom.ui.editorTools.ItemSelectionTool;
import group24.escaperoom.ui.editorTools.MoveTool;
import group24.escaperoom.ui.editorTools.PanTool;
import group24.escaperoom.ui.editorTools.PropertyTool;
import group24.escaperoom.ui.editorTools.RotationTool;
import group24.escaperoom.ui.editorTools.ToolButton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;

public class ToolManager {
    private final HashSet<Brush> brushes = new HashSet();
    private final ButtonGroup<ToolButton> buttons = new ButtonGroup();
    private final ItemDrawer drawer;
    private Optional<EditorTool> activeTool = Optional.empty();
    private HashMap<ToolType, ToolPair> map = new HashMap();
    private ToolButton fillButton;
    private FillTool fillTool;

    public ToolManager(LevelEditorScreen screen, final ItemDrawer drawer) {
        this.buttons.setMaxCheckCount(1);
        this.buttons.setMinCheckCount(0);
        this.buttons.uncheckAll();
        this.drawer = drawer;
        this.addTools(screen);
        drawer.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ItemDrawer.ItemCategory selection = (ItemDrawer.ItemCategory)drawer.getSelection().first();
                if (selection != null) {
                    selection.getBrush().ifPresentOrElse(b -> {
                        if (!ToolManager.this.brushes.contains(b)) {
                            ToolManager.this.brushes.add(b);
                        }
                        ToolManager.this.brushes.forEach(br -> br.cancel());
                        ToolManager.this.buttons.uncheckAll();
                        ToolManager.this.setTool((EditorTool)b);
                    }, () -> ToolManager.this.brushes.forEach(b -> b.cancel()));
                }
            }
        });
    }

    public Array<ToolButton> getToolButons() {
        Array<ToolButton> btns = this.buttons.getButtons();
        btns.add(this.fillButton);
        return btns;
    }

    public EditorTool getTool(ToolType type) {
        return this.map.get((Object)((Object)type)).tool;
    }

    public void addBrush(Brush brush) {
        this.brushes.add(brush);
    }

    private void addTools(LevelEditorScreen screen) {
        this.addTool(new ItemSelectionTool(screen.getUIStage(), screen));
        this.addTool(new DeletionTool(screen));
        this.addTool(new RotationTool(screen));
        this.addTool(new MoveTool(screen.getUIStage(), screen));
        this.addTool(new PanTool(screen));
        this.addTool(new EyeDropTool(screen));
        this.addTool(new PropertyTool(screen));
        this.fillTool = new FillTool(screen);
        this.fillButton = new ToolButton(this.fillTool);
        this.fillButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!ToolManager.this.fillButton.isChecked()) {
                    ToolManager.this.setTool(ToolManager.this.fillTool.getBrush());
                }
            }
        });
        this.fillButton.setDisabled(true);
        this.map.put(ToolType.Fill, new ToolPair(this.fillTool, this.fillButton));
    }

    public void addTool(EditorTool tool) {
        ToolButton b = new ToolButton(tool);
        this.map.put(tool.getType(), new ToolPair(tool, b));
        this.buttons.add(b);
    }

    public boolean canFill() {
        return !this.fillButton.isDisabled();
    }

    public void setTool(EditorTool tool) {
        if (tool.getType() == ToolType.Brush) {
            this.fillButton.setDisabled(false);
            this.fillTool.setBrush((Brush)Brush.class.cast(tool));
            this.buttons.uncheckAll();
        } else if (tool.getType() == ToolType.Fill) {
            this.activeTool.ifPresent(t -> t.cancel());
        } else {
            this.fillButton.setDisabled(true);
            this.fillTool.cancel();
            this.drawer.getSelection().clear();
            this.brushes.forEach(b -> b.cancel());
        }
        BackManager.addBack(() -> {
            if (this.getActiveTool().isEmpty()) {
                return false;
            }
            this.deselectAll();
            return true;
        });
        tool.select();
        this.activeTool = Optional.of(tool);
    }

    public void setTool(ToolType type) {
        boolean alreadyChecked = this.activeTool.map(t -> t.getType() == type).orElse(false);
        BackManager.addBack(() -> {
            if (this.getActiveTool().isEmpty()) {
                return false;
            }
            this.deselectAll();
            return true;
        });
        this.map.get((Object)((Object)type)).button.setChecked(!alreadyChecked);
    }

    public ItemSelectionTool getSelectTool() {
        return (ItemSelectionTool)ItemSelectionTool.class.cast(this.map.get((Object)((Object)ToolType.ItemSelect)).tool);
    }

    public void deselectAll() {
        this.activeTool = Optional.empty();
        this.fillButton.setDisabled(true);
        this.fillTool.cancel();
        this.drawer.getSelection().clear();
        this.brushes.forEach(b -> b.cancel());
        this.buttons.uncheckAll();
    }

    public Optional<EditorTool> getActiveTool() {
        return this.activeTool;
    }

    private class ToolPair {
        final EditorTool tool;
        final ToolButton button;

        public ToolPair(EditorTool t, ToolButton b) {
            this.tool = t;
            this.button = b;
        }
    }

    public static enum ToolType {
        Brush,
        Deletion,
        Fill,
        ItemSelect,
        EyeDrop,
        Properties,
        Move,
        Pan,
        Rotation,
        Selection;


        @Null
        public Input getHotKey() {
            switch (this) {
                case Deletion: {
                    return Input.TOOL_DEL;
                }
                case Fill: {
                    return Input.TOOL_FILL;
                }
                case ItemSelect: {
                    return Input.TOOL_SEL;
                }
                case EyeDrop: {
                    return Input.TOOL_EYEDROP;
                }
                case Properties: {
                    return Input.TOOL_PPT;
                }
                case Move: {
                    return Input.TOOL_MOV;
                }
                case Pan: {
                    return Input.TOOL_PAN;
                }
                case Rotation: {
                    return Input.TOOL_ROT;
                }
                case Selection: 
                case Brush: {
                    return null;
                }
            }
            return null;
        }
    }
}

