/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.GameContext;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.Player;
import group24.escaperoom.entities.player.PlayerAction;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.ui.GameDialog;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.widgets.G24TextButton;
import java.util.HashMap;

public class ActionDialog
extends GameDialog {
    private Array<PlayerAction> actions;
    HashMap<PlayerAction, ActionButton> buttons = new HashMap();
    Item item;

    public ActionDialog(Item item, Player player) {
        super(player, "Actions for " + item.getItemName() + "...");
        this.item = item;
        this.setModal(false);
        GameContext ctx = new GameContext(player.getGameScreen(), player);
        this.actions = item.getPlayerActions(ctx);
        this.getContentTable().add(new ActionButtonGroup());
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.buttons.forEach((a, b) -> {
            if (!a.isValid(new GameContext(this.player.getGameScreen()))) {
                b.setDisabled(true);
            }
        });
    }

    private class ActionButtonGroup
    extends Table {
        public ActionButtonGroup() {
            super(AbstractScreen.skin);
            if (ActionDialog.this.actions.isEmpty()) {
                this.add(new SmallLabel("No available actions for " + ActionDialog.this.item.getItemName()));
            } else {
                for (PlayerAction action : ActionDialog.this.actions) {
                    if (!action.isValid(new GameContext(ActionDialog.this.player.getGameScreen()))) continue;
                    ActionButton b = new ActionButton(action.getActionName(), action, ActionDialog.this.item, ActionDialog.this.player);
                    ActionDialog.this.buttons.put(action, b);
                    this.add(b);
                    this.row();
                }
            }
        }
    }

    public class ActionButton
    extends G24TextButton {
        public ActionButton(String label, final PlayerAction action, Item item, final Player player) {
            super(label);
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    GameContext ctx = new GameContext(player.getGameScreen(), player);
                    if (ActionButton.this.isChecked() && action.isValid(ctx)) {
                        ++player.stats.actionsPerformed;
                        PlayerAction.ActionResult result = action.act(ctx);
                        if (result.completesInteraction()) {
                            ActionDialog.this.hide();
                        }
                        result.getDialog().ifPresent(dialog -> {
                            dialog.show(ActionButton.this.getStage());
                            ActionButton.this.setChecked(false);
                            if (!action.isValid(ctx)) {
                                ActionButton.this.setDisabled(true);
                            }
                        });
                    }
                    ActionButton.this.setChecked(false);
                }
            });
        }
    }
}

