/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editorTools.AreaSelector;
import group24.escaperoom.ui.widgets.G24NumberInput;
import group24.escaperoom.ui.widgets.G24TextButton;

public class AreaUI
extends Table
implements ConfigurationMenu.HandlesMenuClose {
    Integer x;
    Integer y;
    Integer width;
    Integer height;
    G24NumberInput xi;
    G24NumberInput yi;
    G24NumberInput wi;
    G24NumberInput hi;
    boolean selecting = false;
    AreaSelector selector;
    G24TextButton selectAreaButton;
    LevelEditorScreen editor;

    private G24NumberInput numericField(String name, int val, int defaultValue, ModifiesArea mod) {
        G24NumberInput inp = new G24NumberInput(Integer.toString(val));
        inp.setProgrammaticChangeEvents(false);
        inp.setOnEnter(() -> {
            if (inp.getText().isEmpty() || inp.getText().isBlank()) {
                inp.setText(Integer.toString(defaultValue));
            } else {
                mod.modifyarea(Integer.parseInt(inp.getText()));
            }
        });
        inp.addListener(new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (focused) {
                    AreaUI.this.setAreaSelectorActive(false);
                }
            }
        });
        return inp;
    }

    private void setAreaSelectorActive(boolean isActive) {
        if (isActive) {
            this.selector.select();
        } else {
            CursorManager.restoreDefault();
        }
        if (isActive != this.selectAreaButton.isChecked()) {
            this.selectAreaButton.setChecked(isActive);
        }
        this.selecting = isActive;
        this.editor.setPanEnabled(!isActive);
    }

    public AreaUI(LevelEditorScreen editor, Rectangle region) {
        this.selector = new AreaSelector(editor, region);
        this.editor = editor;
        this.xi = this.numericField("x", (int)region.x, 0, i -> {
            region.setX(i);
            this.selector.setRegion(region);
        });
        this.yi = this.numericField("y", (int)region.y, 0, i -> {
            region.setY(i);
            this.selector.setRegion(region);
        });
        this.wi = this.numericField("width", (int)region.width, 0, i -> {
            region.setWidth(i);
            this.selector.setRegion(region);
        });
        this.hi = this.numericField("height", (int)region.height, 0, i -> {
            region.setHeight(i);
            this.selector.setRegion(region);
        });
        this.add(new SmallLabel("x", "bubble", 0.65f));
        this.add(this.xi).row();
        this.add(new SmallLabel("y", "bubble"));
        this.add(this.yi).row();
        this.add(new SmallLabel("width", "bubble", 0.65f));
        this.add(this.wi).row();
        this.add(new SmallLabel("height", "bubble", 0.65f));
        this.add(this.hi).row();
        this.selectAreaButton = new G24TextButton("SelectArea");
        this.selectAreaButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                AreaUI.this.setAreaSelectorActive(AreaUI.this.selectAreaButton.isChecked());
                BackManager.addBack(() -> {
                    if (AreaUI.this.selectAreaButton.isChecked()) {
                        AreaUI.this.selectAreaButton.setChecked(false);
                        return true;
                    }
                    return false;
                });
            }
        });
        this.add(this.selectAreaButton).colspan(2);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.selecting) {
            this.xi.setText(Integer.toString((int)this.selector.getArea().getX()));
            this.yi.setText(Integer.toString((int)this.selector.getArea().getY()));
            this.wi.setText(Integer.toString((int)this.selector.getArea().getWidth()));
            this.hi.setText(Integer.toString((int)this.selector.getArea().getHeight()));
        }
    }

    @Override
    public void handle() {
        this.selector.cancel();
        this.editor.setPanEnabled(true);
    }

    private static interface ModifiesArea {
        public void modifyarea(int var1);
    }
}

