/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import group24.escaperoom.ui.widgets.G24Dialog;
import group24.escaperoom.ui.widgets.G24TextButton;
import java.util.HashMap;

public class ConfirmDialog
extends G24Dialog {
    private Builder builder = new Builder("<no title>");

    public ConfirmDialog(String title) {
        this(new Builder(title));
    }

    private ConfirmDialog(Builder builder) {
        super(builder.title);
        this.setModal(true);
        this.builder = builder;
        if (builder.content != null) {
            this.getContentTable().add(builder.content);
        }
        builder.otherActions.forEach((b, a) -> this.button((Button)b, a));
        this.button(builder.confirmText, (Object)builder.onConfirm);
        this.button(builder.cancelText, (Object)builder.onCancel);
    }

    @Override
    protected void result(Object object) {
        ButtonAction buttonAction = (ButtonAction)object;
        buttonAction.action.run();
        super.result(object);
    }

    public static class Builder {
        private String title;
        private String confirmText = "Confirm";
        private String cancelText = "Cancel";
        private HashMap<G24TextButton, ButtonAction> otherActions = new HashMap();
        private Actor content;
        private ButtonAction onConfirm;
        private ButtonAction onCancel;

        public Builder(String title) {
            this.onConfirm = new ButtonAction(ButtonActionType.Confirm, () -> {});
            this.onCancel = new ButtonAction(ButtonActionType.Cancel, () -> {});
            this.title = title;
        }

        public Builder(Actor content) {
            this.onConfirm = new ButtonAction(ButtonActionType.Confirm, () -> {});
            this.onCancel = new ButtonAction(ButtonActionType.Cancel, () -> {});
            this.content = content;
        }

        public Builder onConfirm(Runnable runnable) {
            this.onConfirm.action = runnable;
            return this;
        }

        public Builder withContent(Actor content) {
            this.content = content;
            return this;
        }

        public Builder onCancel(Runnable runnable) {
            this.onCancel.action = runnable;
            return this;
        }

        public Builder withButton(String buttonText, Runnable action) {
            this.otherActions.put(new G24TextButton(buttonText), new ButtonAction(ButtonActionType.TakeAction, action));
            return this;
        }

        public Builder confirmText(String msg) {
            this.confirmText = msg;
            return this;
        }

        public Builder cancelText(String msg) {
            this.cancelText = msg;
            return this;
        }

        public ConfirmDialog build() {
            return new ConfirmDialog(this);
        }
    }

    private static class ButtonAction {
        ButtonActionType type;
        Runnable action;

        public ButtonAction(ButtonActionType type, Runnable action) {
            this.type = type;
            this.action = action;
        }
    }

    private static enum ButtonActionType {
        Confirm,
        Cancel,
        TakeAction;

    }
}

