/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.data.GameEvent;
import group24.escaperoom.data.GameEventBus;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.Player;
import group24.escaperoom.entities.properties.ContainsItemProperty;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.ui.InteractableItemSlot;
import group24.escaperoom.ui.dnd.ItemPayload;
import java.util.Objects;
import java.util.Optional;

public class ContainerItemSlot
extends InteractableItemSlot {
    ContainsItemProperty prop;
    ContainerItemSlotSource source;
    ContainerItemSlotTarget target;
    GameEventBus.GameEventListener listener;

    @Override
    public void setItem(Item i) {
        super.setItem(i);
        if (this.source == null) {
            this.source = new ContainerItemSlotSource(this);
        }
        if (this.listener == null) {
            this.listener = ev -> {
                if (ev.source.equals(i)) {
                    this.removeItemFromSlot();
                }
            };
        }
        GameEventBus.get().addListener(this.listener, ev -> ev.type == GameEvent.EventType.ItemObtained);
        this.actingPlayer.getGameScreen().getDragAndDrop().addSource(this.source);
        this.actingPlayer.getGameScreen().getDragAndDrop().removeTarget(this.target);
        ContainsItemProperty containsItemProperty = this.prop;
        Objects.requireNonNull(containsItemProperty);
        this.prop.addValue(containsItemProperty.new ContainsItemProperty.ContainedItem(i, this.prop.getOwner()));
    }

    @Override
    public Item removeItemFromSlot() {
        Item removed = super.removeItemFromSlot();
        this.actingPlayer.getGameScreen().getDragAndDrop().removeSource(this.source);
        if (this.target == null) {
            this.target = new ContainerItemSlotTarget(this);
        }
        this.actingPlayer.getGameScreen().getDragAndDrop().addTarget(this.target);
        this.prop.removeItem(removed);
        GameEventBus.get().removeListener(this.listener);
        return removed;
    }

    public ContainerItemSlot(Player actingPlayer, ContainsItemProperty containsProp) {
        super(actingPlayer);
        this.prop = containsProp;
        this.target = new ContainerItemSlotTarget(this);
        actingPlayer.getGameScreen().getDragAndDrop().addTarget(this.target);
    }

    public ContainerItemSlot(Item item, Player actingPlayer, ContainsItemProperty containsProp) {
        super(Optional.of(item), actingPlayer);
        this.prop = containsProp;
        this.source = new ContainerItemSlotSource(this);
        this.listener = ev -> {
            if (ev.source.equals(item)) {
                this.removeItemFromSlot();
            }
        };
        GameEventBus.get().addListener(this.listener, ev -> ev.type == GameEvent.EventType.ItemObtained);
        actingPlayer.getGameScreen().getDragAndDrop().addSource(this.source);
    }

    public class ContainerItemSlotSource
    extends DragAndDrop.Source {
        ContainerItemSlot slot;

        ContainerItemSlotSource(ContainerItemSlot slot) {
            super(slot);
            this.slot = slot;
            slot.addListener(CursorManager.hoverHelper(CursorManager.CursorType.Hand));
        }

        @Override
        public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
            this.slot.inner.slotValues.get().itemPreview.setVisible(false);
            return new ItemPayload(this.slot.inner.slotValues.get().item);
        }

        @Override
        public void dragStop(InputEvent event, float x, float y, int pointer, @Null DragAndDrop.Payload payload, @Null DragAndDrop.Target target) {
            if (target == null || target instanceof ContainerItemSlotTarget) {
                this.slot.inner.slotValues.get().itemPreview.setVisible(true);
            } else {
                ContainerItemSlot.this.removeItemFromSlot();
            }
        }
    }

    public class ContainerItemSlotTarget
    extends DragAndDrop.Target {
        ContainerItemSlot slot;

        public ContainerItemSlotTarget(ContainerItemSlot slot) {
            super(slot);
            this.slot = slot;
        }

        @Override
        public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            this.slot.inner.onHover();
            return true;
        }

        @Override
        public void reset(DragAndDrop.Source source, DragAndDrop.Payload payload) {
            this.slot.inner.onHoverExit();
        }

        @Override
        public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            if (source instanceof ContainerItemSlotSource) {
                return;
            }
            Item i = ((ItemPayload)ItemPayload.class.cast(payload)).getItem();
            ContainerItemSlot.this.setItem(i);
            i.remove();
        }
    }
}

