/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.ui.widgets.G24Dialog;
import group24.escaperoom.ui.widgets.G24TextButton;
import group24.escaperoom.ui.widgets.G24TextInput;
import java.util.Optional;
import java.util.function.Function;

public class CreateMapDialog
extends G24Dialog {
    G24TextInput userInput;
    Function<Optional<String>, Void> ifAdded;

    public CreateMapDialog(Function<Optional<String>, Void> ifAdded) {
        this("Create new map", ifAdded);
    }

    public CreateMapDialog(String title, Function<Optional<String>, Void> ifAdded) {
        super(title);
        this.ifAdded = ifAdded;
        this.userInput = new G24TextInput();
        this.userInput.setFilter(c -> Character.isAlphabetic(c) || Character.isDigit(c) || Character.isWhitespace(c), "Map names can only contain letters, numbers, or spaces");
        this.getContentTable().add(this.userInput).pad(20.0f);
        G24TextButton btn = new G24TextButton("Create");
        this.button(btn, (Object)true);
        btn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                CreateMapDialog.this.hide();
            }
        });
        G24TextButton cancelbtn = new G24TextButton("Cancel");
        this.button(cancelbtn, null);
    }

    @Override
    protected void result(@Null Object object) {
        if (object != null) {
            this.ifAdded.apply(Optional.of(this.userInput.getText()));
        }
        super.result(object);
    }
}

