/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import group24.escaperoom.entities.Item;
import group24.escaperoom.utils.PixMapHelper;

public class DrawingPane
extends Actor {
    private final Pixmap pixmap;
    private final Texture texture;
    private Color currentColor = Color.BLACK;
    public static final Color canvasColor = new Color(0.99607843f, 0.9529412f, 0.7529412f, 1.0f);
    private int lastX;
    private int lastY;
    private boolean drawing;
    private static int brushSize = 1;
    private Brush brush;
    private CircleBrush circleBrush = new CircleBrush();
    private RectangleBrush rectangleBrush = new RectangleBrush();
    private ItemBrush itemBrush = new ItemBrush();

    public DrawingPane(Pixmap pixmap) {
        this.setSize(pixmap.getWidth(), pixmap.getHeight());
        this.pixmap = pixmap;
        this.texture = new Texture(pixmap);
        pixmap.setColor(canvasColor);
        this.updateTexture();
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                event.stop();
                DrawingPane.this.drawing = true;
                int px = (int)x;
                int py = (int)y;
                DrawingPane.this.drawPixel(px, py);
                DrawingPane.this.lastX = px;
                DrawingPane.this.lastY = py;
                return true;
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (DrawingPane.this.drawing) {
                    event.stop();
                    int px = (int)x;
                    int py = (int)y;
                    DrawingPane.this.drawLine(DrawingPane.this.lastX, DrawingPane.this.lastY, px, py);
                    DrawingPane.this.lastX = px;
                    DrawingPane.this.lastY = py;
                }
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                event.stop();
                DrawingPane.this.drawing = false;
            }
        });
    }

    public static int getBrushSize() {
        return brushSize;
    }

    private void drawPixel(int x, int y) {
        this.pixmap.setColor(this.currentColor);
        int invY = (int)this.getHeight() - y;
        this.brush.drawPixel(x, invY);
        this.updateTexture();
    }

    private void drawLine(int x1, int y1, int x2, int y2) {
        this.pixmap.setColor(this.currentColor);
        int invY1 = (int)this.getHeight() - y1;
        int invY2 = (int)this.getHeight() - y2;
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(invY2 - invY1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = invY1 < invY2 ? 1 : -1;
        int err = dx - dy;
        int cx = x1;
        int cy = invY1;
        while (true) {
            this.brush.drawPixel(cx, cy);
            if (cx == x2 && cy == invY2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                cx += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            cy += sy;
        }
        this.updateTexture();
    }

    private void updateTexture() {
        this.texture.draw(this.pixmap, 0, 0);
    }

    public void setDrawColor(Color color) {
        this.currentColor = color;
        this.pixmap.setColor(this.currentColor);
    }

    public void setBrushSize(int size) {
        brushSize = Math.max(1, size);
    }

    public void setBrushShape(BrushShape shape) {
        switch (shape) {
            case Circle: {
                this.brush = this.circleBrush;
                break;
            }
            case Square: {
                this.brush = this.rectangleBrush;
                break;
            }
            case Item: {
                this.brush = this.itemBrush;
            }
        }
    }

    public void setItemBrushItem(Item item) {
        this.itemBrush.setItem((Item)Item.class.cast(item.clone(true)));
    }

    @Override
    public void clear() {
        this.pixmap.setColor(canvasColor);
        this.pixmap.fill();
        this.updateTexture();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        batch.draw(this.texture, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    private class CircleBrush
    implements Brush {
        private CircleBrush() {
        }

        @Override
        public void drawPixel(int x, int y) {
            if (brushSize == 1) {
                DrawingPane.this.pixmap.drawPixel(x, y);
            } else {
                DrawingPane.this.pixmap.fillCircle(x, y, brushSize / 2);
            }
        }
    }

    private class RectangleBrush
    implements Brush {
        private RectangleBrush() {
        }

        @Override
        public void drawPixel(int x, int y) {
            if (brushSize == 1) {
                DrawingPane.this.pixmap.drawPixel(x, y);
            } else {
                DrawingPane.this.pixmap.fillRectangle(x, y, brushSize, brushSize);
            }
        }
    }

    private class ItemBrush
    implements Brush {
        private int lastBrushSize = DrawingPane.access$300();
        private Item currentItem;
        private Pixmap itemPixmap;

        private ItemBrush() {
        }

        public void setItem(Item item) {
            this.currentItem = item;
            this.updateBrush();
        }

        private void updateBrush() {
            if (this.currentItem == null) {
                return;
            }
            if (this.itemPixmap != null) {
                this.itemPixmap.dispose();
            }
            this.itemPixmap = PixMapHelper.fromTextureRegion(new TextureAtlas.AtlasRegion(this.currentItem.getTexture()), brushSize);
            this.lastBrushSize = brushSize;
        }

        @Override
        public void drawPixel(int x, int y) {
            if (this.currentItem == null) {
                return;
            }
            if (this.itemPixmap == null) {
                this.updateBrush();
            }
            if (brushSize != this.lastBrushSize) {
                this.updateBrush();
            }
            DrawingPane.this.pixmap.drawPixmap(this.itemPixmap, x - this.itemPixmap.getWidth() / 2, y - this.itemPixmap.getHeight() / 2);
        }
    }

    private static interface Brush {
        public void drawPixel(int var1, int var2);
    }

    public static enum BrushShape {
        Circle,
        Square,
        Item;

    }
}

