/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.AssetManager;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.DrawingPane;
import group24.escaperoom.ui.ItemSlot;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.widgets.G24ImageButton;
import group24.escaperoom.ui.widgets.G24NumberInput;
import group24.escaperoom.ui.widgets.G24TextButton;

public class DrawingUI
extends Table
implements ConfigurationMenu.HandlesMenuClose {
    DrawingPane pane;
    CheckBox itemBrushCheckBox;

    public DrawingUI(Pixmap pixmap, AbstractScreen screen) {
        LevelEditorScreen editor = (LevelEditorScreen)screen;
        Stack canvas = new Stack();
        AssetManager.instance().load("textures/bkg.9.png", Texture.class);
        AssetManager.instance().finishLoadingAsset("textures/bkg.9.png");
        Texture bkg = AssetManager.instance().get("textures/bkg.9.png", Texture.class);
        NinePatch ninePatch = new NinePatch(bkg, 10, 10, 10, 10);
        NinePatchDrawable drawable = new NinePatchDrawable(ninePatch);
        Image bkgImg = new Image(drawable);
        bkgImg.setTouchable(Touchable.disabled);
        canvas.setSize(pixmap.getWidth() + 40, pixmap.getHeight() + 40);
        canvas.add(bkgImg);
        this.pane = new DrawingPane(pixmap);
        Container<DrawingPane> paneContainer = new Container<DrawingPane>(this.pane);
        paneContainer.pad(20.0f);
        canvas.add(paneContainer);
        ButtonGroup<ColorButton> btnGroup = new ButtonGroup<ColorButton>();
        btnGroup.setMinCheckCount(0);
        btnGroup.setMaxCheckCount(1);
        btnGroup.add(new ColorButton(Color.RED));
        btnGroup.add(new ColorButton(Color.GREEN));
        btnGroup.add(new ColorButton(Color.BLUE));
        btnGroup.add(new ColorButton(Color.BLACK));
        SmallLabel label = new SmallLabel("Brush Size:", "bubble", 0.65f);
        final G24NumberInput numberInput = new G24NumberInput();
        numberInput.setText(Integer.toString(DrawingPane.getBrushSize()));
        numberInput.setMaxLength(2);
        numberInput.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                try {
                    int size = Integer.parseInt(numberInput.getText());
                    DrawingUI.this.pane.setBrushSize(size);
                }
                catch (Exception e) {
                    DrawingUI.this.pane.setBrushSize(1);
                }
            }
        });
        HorizontalGroup hg = new HorizontalGroup();
        for (ColorButton btn : btnGroup.getButtons()) {
            hg.addActor(btn);
        }
        final G24TextButton clearButton = new G24TextButton("Clear");
        clearButton.setProgrammaticChangeEvents(false);
        clearButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                clearButton.setChecked(false);
                DrawingUI.this.pane.clear();
            }
        });
        hg.addActor(label);
        hg.addActor(numberInput);
        final ButtonGroup<CheckBox> itemSelectionGroup = new ButtonGroup<CheckBox>();
        itemSelectionGroup.setMinCheckCount(0);
        itemSelectionGroup.setMaxCheckCount(1);
        Table itemList = new Table();
        itemList.padRight(15.0f);
        itemList.padTop(15.0f);
        itemList.defaults().space(5.0f).left();
        Array<Item> items = new Array<Item>();
        for (Item i : editor.getItemPrototypes()) {
            items.add(i);
            ListEntry e = new ListEntry(i);
            itemList.add(e.getCheck());
            itemList.add(e.label);
            itemList.add(e.slot).row();
            itemSelectionGroup.add(e.getCheck());
        }
        ScrollPane itemSelectPane = new ScrollPane((Actor)itemList, AbstractScreen.skin, "default");
        itemSelectPane.setFadeScrollBars(false);
        itemSelectPane.setForceScroll(false, true);
        itemSelectPane.setScrollBarPositions(false, true);
        HorizontalGroup brushShapes = new HorizontalGroup();
        ButtonGroup<CheckBox[]> shapeGroup = new ButtonGroup<CheckBox[]>();
        shapeGroup.setMinCheckCount(0);
        shapeGroup.setMaxCheckCount(1);
        final CheckBox circle = new CheckBox("Circle", AbstractScreen.skin);
        circle.setChecked(true);
        circle.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (circle.isChecked()) {
                    itemSelectionGroup.uncheckAll();
                    DrawingUI.this.pane.setBrushShape(DrawingPane.BrushShape.Circle);
                }
            }
        });
        final CheckBox square = new CheckBox("Square", AbstractScreen.skin);
        square.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (square.isChecked()) {
                    itemSelectionGroup.uncheckAll();
                    DrawingUI.this.pane.setBrushShape(DrawingPane.BrushShape.Square);
                }
            }
        });
        this.itemBrushCheckBox = new CheckBox("Item", AbstractScreen.skin);
        this.itemBrushCheckBox.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (DrawingUI.this.itemBrushCheckBox.isChecked()) {
                    DrawingUI.this.pane.setBrushShape(DrawingPane.BrushShape.Item);
                }
            }
        });
        shapeGroup.add(new CheckBox[]{circle, square, this.itemBrushCheckBox});
        brushShapes.addActor(circle);
        brushShapes.addActor(this.itemBrushCheckBox);
        brushShapes.addActor(square);
        this.add(canvas).center().colspan(2);
        this.row();
        this.add(hg).center().colspan(2);
        this.row();
        this.add(label).left();
        this.add(numberInput).left().maxWidth(60.0f);
        this.row();
        this.add(new SmallLabel("Shape:", "bubble", 0.65f)).left();
        this.add(brushShapes).left();
        this.row();
        this.add(new SmallLabel("Item Brush", "title")).center().colspan(2);
        this.row();
        this.add(itemSelectPane).center().maxHeight(300.0f).colspan(2);
        this.row();
        this.add(clearButton).center().colspan(2);
    }

    @Override
    public void handle() {
    }

    private class ColorButton
    extends G24ImageButton {
        public ColorButton(final Color color) {
            this.getImage().setColor(color);
            this.setProgrammaticChangeEvents(false);
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (ColorButton.this.isChecked()) {
                        DrawingUI.this.pane.setDrawColor(color);
                    }
                }
            });
        }
    }

    private class ListEntry {
        CheckBox check;
        SmallLabel label;
        ItemSlot slot;
        Item item;

        public ListEntry(Item i) {
            this.item = i;
            this.check = new CheckBox("", AbstractScreen.skin);
            this.check.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (ListEntry.this.check.isChecked()) {
                        DrawingUI.this.itemBrushCheckBox.setChecked(true);
                        DrawingUI.this.pane.setItemBrushItem(ListEntry.this.item);
                    }
                }
            });
            this.label = new SmallLabel(this.item.getItemName(), "default", 0.65f);
            this.slot = new ItemSlot(this.item);
        }

        public CheckBox getCheck() {
            return this.check;
        }
    }
}

