/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.data.MapLoader;
import group24.escaperoom.data.User;
import group24.escaperoom.screens.MainMenuScreen;
import group24.escaperoom.screens.MapSelectScreen;
import group24.escaperoom.screens.OnlineMainMenu;
import group24.escaperoom.ui.SettingsDialog;
import group24.escaperoom.ui.widgets.G24TextButton;

public class EditorSettingsDialog
extends SettingsDialog {
    public EditorSettingsDialog() {
        this.button(new MainMenuButton());
        this.button(new MapSelectButton());
    }

    private class MainMenuButton
    extends G24TextButton {
        public MainMenuButton() {
            super("Main Menu");
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    ScreenManager.instance().showScreen(User.isLoggedIn() ? new OnlineMainMenu() : new MainMenuScreen());
                }
            });
        }
    }

    private class MapSelectButton
    extends G24TextButton {
        public MapSelectButton() {
            super("Map Select");
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    ScreenManager.instance().showScreen(new MapSelectScreen.MapSelectScreenBuilder(User.isLoggedIn() ? new OnlineMainMenu() : new MainMenuScreen()).withMaps(MapLoader.discoverMaps()).edit().play().delete().verify().creation().build());
                }
            });
        }
    }
}

