/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.data.MapData;
import group24.escaperoom.data.MapSaver;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.objects.ObjectLoader;
import group24.escaperoom.entities.objects.ObjectTypeData;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.Stylable;
import group24.escaperoom.screens.ItemEditor;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.ActionHistory;
import group24.escaperoom.screens.editor.DragManager;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.editorTools.ItemDrawer;
import group24.escaperoom.ui.editorTools.ToolButton;
import group24.escaperoom.ui.widgets.G24TextButton;
import group24.escaperoom.utils.Notifier;
import java.util.Arrays;
import java.util.Objects;

public class EditorUI {
    private final LevelEditorScreen screen;
    private final EditorUITable root;
    private final ItemDrawer itemDrawer;
    private final Hints hints;
    private final Table toolDrawer = new Table();

    public Hints getHints() {
        return this.hints;
    }

    public EditorUI(LevelEditorScreen screen, ToolManager tools, DragManager drag, ActionHistory history, ItemDrawer drawer) {
        this.itemDrawer = drawer;
        this.screen = screen;
        this.root = new EditorUITable();
        this.hints = new Hints();
        this.buildItemDrawer(screen);
        this.buildToolDrawer(tools, history);
        this.buildUI(screen);
    }

    public boolean clearSelections() {
        if (!this.itemDrawer.getSelection().isEmpty()) {
            this.itemDrawer.getSelection().clear();
            return true;
        }
        return false;
    }

    private void buildUI(final LevelEditorScreen screen) {
        this.root.defaults();
        this.root.setFillParent(true);
        this.root.top().left();
        Menu sideBar = new Menu(null, screen.getMetadata().name, screen);
        sideBar.defaults().width(250.0f);
        sideBar.setMovable(false);
        sideBar.add(new Menu.MenuEntryBuilder(sideBar, "Game Settings").spawns(p -> {
            Menu m = new Menu(p, "Game Options", screen);
            m.add(new Menu.MenuEntryBuilder(m, "Persistent FOW").selectable(screen.getMetadata().gameSettings.persistentReveal).onSelect(() -> {
                screen.getMetadata().gameSettings.persistentReveal = true;
            }).onDeselect(() -> {
                screen.getMetadata().gameSettings.persistentReveal = false;
            }).build());
            return m;
        }).build()).row();
        sideBar.addDivider();
        sideBar.add(Menu.MenuEntry.label("Tools")).row();
        sideBar.addDivider();
        sideBar.add(this.toolDrawer).center().pad(0.0f).row();
        sideBar.addDivider();
        sideBar.add(Menu.MenuEntry.label("Items")).row();
        sideBar.addDivider();
        final ScrollPane scrollWrapper = new ScrollPane((Actor)this.itemDrawer);
        sideBar.add(scrollWrapper).growY().padTop(10.0f).padBottom(10.0f).row();
        scrollWrapper.addListener(new InputListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                screen.getUIStage().setScrollFocus(scrollWrapper);
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                screen.getUIStage().setScrollFocus(null);
            }
        });
        final G24TextButton playButton = new G24TextButton("Play");
        playButton.setProgrammaticChangeEvents(false);
        playButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (playButton.isChecked()) {
                    boolean s = MapSaver.saveMap(screen.getGrid(), screen.getMetadata());
                    if (s) {
                        screen.setPlayMode();
                        playButton.setChecked(false);
                    } else {
                        Notifier.warn("Failed to save map");
                    }
                }
            }
        });
        final G24TextButton saveButton = new G24TextButton("Save");
        saveButton.setProgrammaticChangeEvents(false);
        saveButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (saveButton.isChecked()) {
                    boolean s = MapSaver.saveMap(screen.getGrid(), screen.getMetadata());
                    if (s) {
                        Notifier.info("Map saved");
                    } else {
                        Notifier.warn("Map failed to save");
                    }
                    saveButton.setChecked(false);
                }
            }
        });
        final G24TextButton newItemBtn = new G24TextButton("  New Item");
        newItemBtn.setProgrammaticChangeEvents(false);
        newItemBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (newItemBtn.isChecked()) {
                    if (MapSaver.saveMap(screen.grid, screen.getMetadata())) {
                        ScreenManager.instance().showScreen(new ItemEditor(new MapData(screen.grid, screen.getMetadata()), null));
                    } else {
                        Notifier.error("Failed to save map");
                    }
                    newItemBtn.setChecked(false);
                }
            }
        });
        final G24TextButton reloadBtn = new G24TextButton("  Reload Items");
        reloadBtn.setProgrammaticChangeEvents(false);
        reloadBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                screen.reloadItems();
                Notifier.error("reloaded all items");
                reloadBtn.setChecked(false);
            }
        });
        HorizontalGroup hg = new HorizontalGroup();
        hg.addActor(saveButton);
        hg.addActor(playButton);
        VerticalGroup vg = new VerticalGroup();
        vg.addActor(newItemBtn);
        vg.addActor(reloadBtn);
        vg.grow();
        sideBar.add(vg).center().pad(0.0f);
        this.root.add(sideBar).left().top().growY();
        this.root.add(this.hints).bottom().left().expandX().padLeft(5.0f).padBottom(5.0f);
        this.root.add(hg).expandX().right().bottom().padRight(5.0f);
    }

    private void buildToolDrawer(ToolManager toolManager, ActionHistory history) {
        this.toolDrawer.defaults().center().pad(2.0f);
        int count = 0;
        for (ToolButton tb : toolManager.getToolButons()) {
            this.toolDrawer.add(tb);
            if (++count <= 0 || count % 4 != 0) continue;
            this.toolDrawer.row();
        }
        this.toolDrawer.row();
        this.toolDrawer.add(history.getUndoButton());
        this.toolDrawer.add(history.getRedoButton());
        this.toolDrawer.pack();
    }

    private void buildItemDrawer(LevelEditorScreen screen) {
        boolean usesDefaultItems = screen.getMetadata().gameSettings.usesDefaultItems;
        Object[] categories = usesDefaultItems ? ObjectLoader.LoadedObjects.getCategories().toArray(new String[0]) : ObjectLoader.LoadedObjects.getUserCategories().toArray(new String[0]);
        Arrays.sort(categories);
        for (Object category : categories) {
            ItemDrawer itemDrawer = this.itemDrawer;
            Objects.requireNonNull(itemDrawer);
            ItemDrawer.ItemCategory objCategory = new ItemDrawer.ItemCategory(itemDrawer, (String)category);
            this.itemDrawer.add(objCategory);
            ObjectTypeData[] typeDatas = usesDefaultItems ? ObjectLoader.LoadedObjects.getItems((String)category).toArray(new ObjectTypeData[0]) : ObjectLoader.LoadedObjects.getUserItems((String)category).toArray(new ObjectTypeData[0]);
            Arrays.sort(typeDatas, (a, b) -> a.name.compareTo(b.name));
            for (ObjectTypeData itemType : typeDatas) {
                Item i = new Item(itemType);
                if (i.hasProperty(PropertyType.Stylable)) {
                    Stylable prop = i.getProperty(PropertyType.Stylable, Stylable.class).get();
                    for (Stylable.Style s : prop.getPotentialValues()) {
                        Item styleItem = new Item(itemType);
                        styleItem.getProperty(PropertyType.Stylable, Stylable.class).get().set(s);
                        ItemDrawer itemDrawer2 = this.itemDrawer;
                        Objects.requireNonNull(itemDrawer2);
                        ItemDrawer.ItemNode n = new ItemDrawer.ItemNode(itemDrawer2, styleItem);
                        objCategory.add(n);
                    }
                    continue;
                }
                ItemDrawer itemDrawer3 = this.itemDrawer;
                Objects.requireNonNull(itemDrawer3);
                ItemDrawer.ItemNode n = new ItemDrawer.ItemNode(itemDrawer3, i);
                objCategory.add(n);
            }
        }
    }

    public Table getRoot() {
        return this.root;
    }

    public class Hints
    extends HorizontalGroup {
        public final ItemHint itemHint;
        public final CoordHints coordHints;

        public Hints() {
            this.itemHint = new ItemHint();
            this.coordHints = new CoordHints();
            this.space(10.0f);
            this.addActor(this.coordHints);
            this.addActor(this.itemHint);
        }
    }

    private class EditorUITable
    extends Table {
        EditorUITable() {
            EditorUI.this.screen.addCaptureListener(new InputListener(){

                @Override
                public boolean mouseMoved(InputEvent event, float x, float y) {
                    Types.IntVector2 pos = new Types.IntVector2(x, y);
                    ((EditorUI)EditorUI.this).hints.coordHints.update(pos.x, pos.y);
                    ((EditorUI)EditorUI.this).hints.itemHint.update(pos.x, pos.y);
                    return false;
                }
            });
        }
    }

    public class CoordHints
    extends HorizontalGroup {
        private SmallLabel coords = new SmallLabel("x: _ y: _", "bubble", 0.6f);
        private final int maxX;
        private final int maxY;

        public CoordHints() {
            this.maxX = 47;
            this.maxY = 26;
            this.space(5.0f);
            this.addActor(this.coords);
        }

        public void update(Rectangle r) {
            this.coords.setText("x: " + (int)r.getX() + " y: " + (int)r.getY() + " width: " + (int)r.getWidth() + " height: " + (int)r.getHeight());
        }

        public void update(int x, int y) {
            if (x < 0 || x > this.maxX || y < 0 || y > this.maxY) {
                this.coords.setText("x: - y: -");
            } else {
                this.coords.setText("x: " + x + " y: " + y);
            }
        }
    }

    public class ItemHint
    extends SmallLabel {
        ItemHintMode hintMode;

        ItemHint() {
            super("<no item> ID: -", "bubble", 0.6f);
            this.hintMode = ItemHintMode.Hover;
        }

        public void update(int x, int y) {
            switch (this.hintMode) {
                case Hover: {
                    this.setItem(EditorUI.this.screen.priorityItemAt(x, y).orElse(null));
                    break;
                }
                case Selected: {
                    this.setItem(EditorUI.this.screen.getSelectedItem().orElse(null));
                }
            }
        }

        private void setItem(Item i) {
            if (i == null) {
                this.setText("<no item> ID: -");
                return;
            }
            this.setText(i.getItemName() + " ID: " + i.getID());
        }

        public void setMode(ItemHintMode mode) {
            this.hintMode = mode;
            float x = Gdx.input.getX();
            float y = Gdx.input.getY();
            Types.IntVector2 pos = Types.IntVector2.fromVector2(EditorUI.this.screen.screenToStageCoordinates(new Vector2(x, y)));
            this.update(pos.x, pos.y);
        }
    }

    public static enum ItemHintMode {
        Hover,
        Selected;

    }
}

