/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.data.Types;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.widgets.G24Dialog;
import group24.escaperoom.ui.widgets.G24TextButton;
import group24.escaperoom.ui.widgets.G24TextInput;
import group24.escaperoom.utils.Notifier;
import java.util.Optional;
import java.util.function.BiFunction;

public class FilterUI
extends G24Dialog {
    DragAndDrop dragAndDrop = new DragAndDrop();
    private VerticalGroup methodSources = new VerticalGroup();
    private VerticalGroup fieldSources = new VerticalGroup();
    private SearchBuilderBox box;

    public <E extends Enum<E>> FilterUI(final BiFunction<Types.Filters, Types.Sort, Void> onSearch, Class<E> fieldType) {
        super("Sort and Filter Results");
        this.fieldSources.space(10.0f);
        this.fieldSources.columnLeft();
        this.methodSources.space(10.0f);
        this.methodSources.columnLeft();
        this.dragAndDrop.addTarget(new ReturnBin(this.fieldSources));
        this.dragAndDrop.addTarget(new ReturnBin(this.methodSources));
        Enum aFieldInstance = null;
        for (Enum enum_ : (Enum[])fieldType.getEnumConstants()) {
            this.fieldSources.addActor(new FieldSourceLabel((Types.IsField)((Object)enum_)));
            aFieldInstance = enum_;
        }
        for (Enum enum_ : Types.Filter.Method.values()) {
            this.methodSources.addActor(new MethodSourceLabel((Types.Filter.Method)enum_));
        }
        this.box = new SearchBuilderBox(aFieldInstance.defaultSort());
        final G24TextButton searchButton = new G24TextButton("Search");
        searchButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (searchButton.isChecked()) {
                    searchButton.setChecked(false);
                    FilterUI.this.setVisible(false);
                    onSearch.apply(FilterUI.this.getFilters(), FilterUI.this.getSort());
                }
            }
        });
        final G24TextButton closeButton = new G24TextButton("Close");
        closeButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (closeButton.isChecked()) {
                    closeButton.setChecked(false);
                    FilterUI.this.setVisible(false);
                }
            }
        });
        this.getContentTable().add(new SmallLabel("Fields", "title")).center();
        this.getContentTable().add(new SmallLabel("Methods", "title")).center().row();
        this.getContentTable().add(this.fieldSources).top();
        this.getContentTable().add(this.methodSources).top();
        this.getContentTable().add(this.box).top().row();
        this.getButtonTable().add(searchButton);
        this.getButtonTable().add(closeButton);
    }

    private static String filterDisplayString(Types.Filter.Method m) {
        switch (m) {
            case Equals: {
                return "Equals";
            }
            case GreaterThan: {
                return "Greater than";
            }
            case GreaterThanEqualTo: {
                return "Greater than equal to";
            }
            case LessThan: {
                return "Less than";
            }
            case LessThanEqualTo: {
                return "Less than or equal to";
            }
            case NotEquals: {
                return "Not equal to";
            }
        }
        return "<invalid filter type>";
    }

    public Types.Sort getSort() {
        return new Types.Sort(this.box.sortField.toString(), this.box.sortDir);
    }

    public Types.Filters getFilters() {
        return this.box.getFilters();
    }

    private class ReturnBin
    extends DragAndDrop.Target {
        ReturnBin(Actor a) {
            super(a);
        }

        @Override
        public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            return true;
        }

        @Override
        public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
        }
    }

    private class FieldSourceLabel
    extends SmallLabel {
        FieldSourceLabel(Types.IsField field) {
            super(field.displayName(), "bubble");
            FilterUI.this.dragAndDrop.addSource(new FieldBankSource(this, field));
        }
    }

    private class MethodSourceLabel
    extends SmallLabel {
        MethodSourceLabel(Types.Filter.Method method) {
            super(FilterUI.filterDisplayString(method), "bubble");
            FilterUI.this.dragAndDrop.addSource(new MethodBankSource(this, method));
        }
    }

    private class SearchBuilderBox
    extends VerticalGroup {
        private G24TextButton addFilterButton;
        private Types.IsField sortField = null;
        private Types.Filters.Combination combination = Types.Filters.Combination.And;
        private Types.Sort.Direction sortDir = Types.Sort.Direction.Descending;

        public SearchBuilderBox(Types.IsField defaultSortField) {
            this.columnLeft();
            this.space(10.0f);
            this.sortField = defaultSortField;
            this.addFilterButton = new G24TextButton("Add Filter");
            this.addFilterButton.setProgrammaticChangeEvents(false);
            this.addFilterButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (SearchBuilderBox.this.addFilterButton.isChecked()) {
                        SearchBuilderBox.this.addFilterButton.setChecked(false);
                        SearchBuilderBox.this.addEmptyFilterEntry();
                        FilterUI.this.pack();
                    }
                }
            });
            HorizontalGroup filterComboBox = new HorizontalGroup();
            ButtonGroup<CheckBox[]> filterComboBtnGroup = new ButtonGroup<CheckBox[]>();
            final CheckBox andCombo = new CheckBox("And", AbstractScreen.skin);
            final CheckBox orCombo = new CheckBox("Or", AbstractScreen.skin);
            filterComboBtnGroup.add(new CheckBox[]{andCombo, orCombo});
            andCombo.setChecked(true);
            filterComboBox.addActor(new SmallLabel("Filter Combination:", "title"));
            filterComboBox.addActor(andCombo);
            filterComboBox.addActor(orCombo);
            andCombo.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (andCombo.isChecked()) {
                        SearchBuilderBox.this.combination = Types.Filters.Combination.And;
                    }
                }
            });
            orCombo.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (orCombo.isChecked()) {
                        SearchBuilderBox.this.combination = Types.Filters.Combination.Or;
                    }
                }
            });
            HorizontalGroup sortOnBox = new HorizontalGroup();
            final SmallLabel fieldLabel = new SmallLabel(defaultSortField.displayName(), "bubble");
            ButtonGroup<CheckBox[]> sortDirGroup = new ButtonGroup<CheckBox[]>();
            final CheckBox ascCheck = new CheckBox("Ascending", AbstractScreen.skin);
            final CheckBox descCheck = new CheckBox("Descending", AbstractScreen.skin);
            sortDirGroup.add(new CheckBox[]{ascCheck, descCheck});
            descCheck.setChecked(true);
            ascCheck.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (ascCheck.isChecked()) {
                        SearchBuilderBox.this.sortDir = Types.Sort.Direction.Ascending;
                    }
                }
            });
            descCheck.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (descCheck.isChecked()) {
                        SearchBuilderBox.this.sortDir = Types.Sort.Direction.Descending;
                    }
                }
            });
            FilterUI.this.dragAndDrop.addTarget(new DragAndDrop.Target(fieldLabel){

                @Override
                public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                    return source instanceof FieldBankSource;
                }

                @Override
                public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                    FieldPayload s = (FieldPayload)FieldPayload.class.cast(payload);
                    SearchBuilderBox.this.sortField = s.getField();
                    fieldLabel.setText(s.getField().displayName());
                }
            });
            sortOnBox.addActor(new SmallLabel("Sort on:", "title"));
            sortOnBox.addActor(fieldLabel);
            sortOnBox.addActor(descCheck);
            sortOnBox.addActor(ascCheck);
            this.addActor(new FilterEntry());
            this.addActor(this.addFilterButton);
            this.addActor(filterComboBox);
            this.addActor(sortOnBox);
            FilterUI.this.pack();
        }

        public void addEmptyFilterEntry() {
            for (Actor a : this.getChildren()) {
                if (!(a instanceof FilterEntry) || ((FilterEntry)FilterEntry.class.cast(a)).isComplete()) continue;
                Notifier.warn("Complete previous filter", a);
                return;
            }
            this.addActorBefore(this.addFilterButton, new FilterEntry());
        }

        public Types.Filters getFilters() {
            Array<Types.Filter> ret = new Array<Types.Filter>();
            for (Actor a : this.getChildren()) {
                if (!(a instanceof FilterEntry)) continue;
                FilterEntry e = (FilterEntry)FilterEntry.class.cast(a);
                if (!e.isComplete()) {
                    Notifier.warn("Filter is not complete", e);
                    continue;
                }
                Types.Filter f = null;
                Types.FilterConstType t = e.field.get().getConstType();
                switch (t) {
                    case Integer: {
                        Integer i = 0;
                        try {
                            i = Integer.parseInt(e.valueInput.getText().trim());
                        }
                        catch (NumberFormatException nfe) {
                            Notifier.warn("Couldn't parse number from: \"" + e.valueInput.getText() + "\", using 0");
                        }
                        f = new Types.Filter(e.field.get().toString(), e.method.get(), i);
                        break;
                    }
                    case String: {
                        f = new Types.Filter(e.field.get().toString(), e.method.get(), e.valueInput.getText());
                        break;
                    }
                }
                if (f == null) continue;
                ret.add(f);
            }
            return new Types.Filters(this.combination, ret.toArray(Types.Filter.class));
        }
    }

    private static class MethodPayload
    extends DragAndDrop.Payload {
        public MethodPayload(Types.Filter.Method method) {
            String s = FilterUI.filterDisplayString(method);
            SmallLabel actor = new SmallLabel(s, "bubble");
            actor.pack();
            this.setDragActor(actor);
            SmallLabel invalid = new SmallLabel(s, "bubble");
            invalid.setColor(1.0f, 0.8f, 0.8f, 0.8f);
            invalid.pack();
            this.setInvalidDragActor(invalid);
            SmallLabel valid = new SmallLabel(s, "bubble");
            valid.setColor(0.8f, 1.0f, 0.8f, 0.8f);
            valid.pack();
            this.setValidDragActor(valid);
            this.setObject((Object)method);
        }

        public Types.Filter.Method getMethod() {
            return (Types.Filter.Method)((Object)Types.Filter.Method.class.cast(this.getObject()));
        }
    }

    private static class FieldPayload
    extends DragAndDrop.Payload {
        public FieldPayload(Types.IsField field) {
            SmallLabel actor = new SmallLabel(field.displayName(), "bubble");
            actor.pack();
            this.setDragActor(actor);
            SmallLabel invalid = new SmallLabel(field.displayName(), "bubble");
            invalid.setColor(1.0f, 0.8f, 0.8f, 0.8f);
            invalid.pack();
            this.setInvalidDragActor(invalid);
            SmallLabel valid = new SmallLabel(field.displayName(), "bubble");
            valid.setColor(0.8f, 1.0f, 0.8f, 0.8f);
            valid.pack();
            this.setValidDragActor(valid);
            this.setObject(field);
        }

        public Types.IsField getField() {
            return (Types.IsField)Types.IsField.class.cast(this.getObject());
        }
    }

    private class FilterEntry
    extends HorizontalGroup {
        Optional<Types.Filter.Method> method = Optional.empty();
        Optional<Types.IsField> field = Optional.empty();
        private SmallLabel fieldLabel;
        private SmallLabel methodLabel;
        private MethodTarget methodTarget;
        private FieldTarget fieldTarget;
        private MethodSource methodSource;
        private FieldSource fieldSource;
        private G24TextInput valueInput;

        public boolean isComplete() {
            return this.method.isPresent() && this.field.isPresent();
        }

        public FilterEntry() {
            this.space(5.0f);
            this.valueInput = new G24TextInput();
            this.methodLabel = new SmallLabel("<empty>", "bubble");
            this.methodTarget = new MethodTarget(this.methodLabel);
            this.fieldLabel = new SmallLabel("<empty>", "bubble");
            this.fieldTarget = new FieldTarget(this.fieldLabel);
            FilterUI.this.dragAndDrop.addTarget(this.methodTarget);
            FilterUI.this.dragAndDrop.addTarget(this.fieldTarget);
            this.methodSource = new MethodSource();
            this.fieldSource = new FieldSource();
            this.addActor(this.fieldLabel);
            this.addActor(this.methodLabel);
            this.addActor(this.valueInput);
            ImageButton removeFilterButton = new ImageButton(AbstractScreen.skin, "toggleForbidden");
            removeFilterButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    FilterEntry.this.remove();
                    FilterUI.this.pack();
                }
            });
            this.addActor(removeFilterButton);
        }

        public void clearMethod() {
            this.method = Optional.empty();
            this.methodLabel.setText("<empty>");
            this.methodLabel.pack();
            FilterUI.this.pack();
            FilterUI.this.dragAndDrop.removeSource(this.methodSource);
            FilterUI.this.dragAndDrop.addTarget(this.methodTarget);
        }

        public void setMethod(Types.Filter.Method filter) {
            this.method = Optional.of(filter);
            this.methodLabel.setText(FilterUI.filterDisplayString(filter));
            this.methodLabel.pack();
            FilterUI.this.pack();
            FilterUI.this.dragAndDrop.removeTarget(this.methodTarget);
            FilterUI.this.dragAndDrop.addSource(this.methodSource);
        }

        public void clearField() {
            this.field = Optional.empty();
            this.fieldLabel.setText("<empty>");
            this.fieldLabel.pack();
            FilterUI.this.pack();
            this.valueInput.setFilter(c -> true);
            FilterUI.this.dragAndDrop.removeSource(this.fieldSource);
            FilterUI.this.dragAndDrop.addTarget(this.fieldTarget);
        }

        public void setField(Types.IsField field) {
            this.field = Optional.of(field);
            FilterUI.this.dragAndDrop.removeTarget(this.fieldTarget);
            FilterUI.this.dragAndDrop.addSource(this.fieldSource);
            this.fieldLabel.setText(field.displayName());
            this.fieldLabel.pack();
            FilterUI.this.pack();
            switch (field.getConstType()) {
                case Integer: {
                    this.valueInput.setFilter(c -> Character.isDigit(c));
                    break;
                }
                case String: {
                    this.valueInput.setFilter(c -> true);
                    break;
                }
            }
        }

        private class MethodTarget
        extends DragAndDrop.Target {
            public MethodTarget(Actor target) {
                super(target);
            }

            @Override
            public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                if (!(source instanceof MethodBankSource)) {
                    return false;
                }
                return !FilterEntry.this.method.isPresent();
            }

            @Override
            public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                MethodPayload s = (MethodPayload)MethodPayload.class.cast(payload);
                FilterEntry.this.setMethod(s.getMethod());
            }
        }

        private class FieldTarget
        extends DragAndDrop.Target {
            public FieldTarget(Actor target) {
                super(target);
            }

            @Override
            public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                if (!(source instanceof FieldBankSource)) {
                    return false;
                }
                return !FilterEntry.this.field.isPresent();
            }

            @Override
            public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                FieldPayload s = (FieldPayload)FieldPayload.class.cast(payload);
                FilterEntry.this.setField(s.getField());
            }
        }

        private class MethodSource
        extends DragAndDrop.Source {
            MethodSource() {
                super(FilterEntry.this.methodLabel);
            }

            @Override
            public void dragStop(InputEvent event, float x, float y, int pointer, @Null DragAndDrop.Payload payload, @Null DragAndDrop.Target target) {
                FilterEntry.this.methodLabel.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                if (target != null) {
                    FilterEntry.this.clearMethod();
                }
            }

            @Override
            public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
                FilterEntry.this.methodLabel.setColor(1.0f, 1.0f, 1.0f, 0.2f);
                return new MethodPayload(FilterEntry.this.method.get());
            }
        }

        private class FieldSource
        extends DragAndDrop.Source {
            FieldSource() {
                super(FilterEntry.this.fieldLabel);
            }

            @Override
            public void dragStop(InputEvent event, float x, float y, int pointer, @Null DragAndDrop.Payload payload, @Null DragAndDrop.Target target) {
                FilterEntry.this.fieldLabel.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                if (target != null) {
                    FilterEntry.this.clearField();
                }
            }

            @Override
            public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
                FilterEntry.this.fieldLabel.setColor(1.0f, 1.0f, 1.0f, 0.2f);
                return new FieldPayload(FilterEntry.this.field.get());
            }
        }
    }

    private class MethodBankSource
    extends DragAndDrop.Source {
        Types.Filter.Method method;

        public MethodBankSource(Actor sourceActor, Types.Filter.Method method) {
            super(sourceActor);
            this.method = method;
        }

        @Override
        public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
            return new MethodPayload(this.method);
        }
    }

    private class FieldBankSource
    extends DragAndDrop.Source {
        Types.IsField field;

        public FieldBankSource(Actor sourceActor, Types.IsField field) {
            super(sourceActor);
            this.field = field;
        }

        @Override
        public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
            return new FieldPayload(this.field);
        }
    }
}

