/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.Player;
import group24.escaperoom.ui.ItemSlot;
import java.util.Optional;

public class InteractableItemSlot
extends ItemSlot {
    protected Player actingPlayer;
    private ClickListener clickListener = new ClickListener(){

        @Override
        public void clicked(InputEvent event, float x, float y) {
            InteractableItemSlot.this.inner.onClick(InteractableItemSlot.this.actingPlayer, InteractableItemSlot.this.getStage());
        }
    };
    private InputListener hoverListeners = new InputListener(){

        @Override
        public void enter(InputEvent event, float x, float y, int pointer, @Null Actor fromActor) {
            InteractableItemSlot.this.inner.onHover();
        }

        @Override
        public void exit(InputEvent event, float x, float y, int pointer, @Null Actor toActor) {
            InteractableItemSlot.this.inner.onHoverExit();
        }
    };

    public InteractableItemSlot(Player actingPlayer) {
        this(Optional.empty(), actingPlayer);
    }

    public InteractableItemSlot(Item item, Player actingPlayer) {
        this(Optional.of(item), actingPlayer);
    }

    protected void addListeners() {
        this.addListener(this.clickListener);
        this.addListener(this.hoverListeners);
    }

    protected void removeListeners() {
        this.removeListener(this.clickListener);
        this.removeListener(this.hoverListeners);
    }

    protected void setItem(Item item) {
        this.inner.setItem(item);
        this.addListeners();
    }

    protected Item removeItemFromSlot() {
        this.removeListeners();
        return this.inner.removeItem();
    }

    public InteractableItemSlot(Optional<Item> item, Player actingPlayer) {
        super(item);
        this.actingPlayer = actingPlayer;
        item.ifPresent(i -> this.addListeners());
    }
}

