/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.Input;
import group24.escaperoom.control.InputOverride;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.GridView;
import group24.escaperoom.screens.editor.ItemDecoration;
import group24.escaperoom.ui.SelectableItemSlot;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ItemSelectUI
extends Table
implements ConfigurationMenu.HandlesMenuClose {
    private Function<Item, Void> onSelect = i -> null;
    private Function<Item, Void> onDeselect = i -> null;
    private Array<SelectedItem> selected = new Array();
    private Array<Item> canidateItems = new Array();
    private LevelEditorScreen editor = null;
    private boolean allowMultiple;
    private SelectInputOverride selectInputOverride = new SelectInputOverride();
    private HashMap<Integer, SelectableItemSlot> itemSlotMap = new HashMap();

    public void setOnSelect(Function<Item, Void> onSelect) {
        this.onSelect = onSelect;
    }

    public void setOnDeselect(Function<Item, Void> onDeselect) {
        this.onDeselect = onDeselect;
    }

    private void deselectItem(Item item) {
        if (this.allowMultiple) {
            this.selected.removeValue(new SelectedItem(item), false);
        } else if (this.selected.first().getItem() == null || this.selected.first().getItem().getID() == item.getID()) {
            this.selected.first().setItem(null);
        }
        item.setSelected(false);
        this.itemSlotMap.get(item.getID()).setSelected(false);
        this.onDeselect.apply(item);
    }

    private void selectItem(Item item) {
        if (this.allowMultiple) {
            this.selected.add(new SelectedItem(item));
        } else {
            this.selected.first().setItem(item);
            for (int itemID : this.itemSlotMap.keySet()) {
                if (itemID == item.getID()) continue;
                this.itemSlotMap.get((Object)Integer.valueOf((int)itemID)).inner.slotValues.ifPresent(i -> this.deselectItem(i.item));
            }
        }
        item.setSelected(true);
        this.itemSlotMap.get(item.getID()).setSelected(true);
        this.onSelect.apply(item);
    }

    public ItemSelectUI(Array<Item> potentialItems, String emptyMessage, Array<SelectedItem> mutSelections, boolean allowMultiple, AbstractScreen screen) {
        this.pad(10.0f);
        this.canidateItems = potentialItems;
        this.selected = mutSelections;
        this.editor = (LevelEditorScreen)screen;
        this.allowMultiple = allowMultiple;
        if (this.canidateItems.isEmpty()) {
            this.add(new SmallLabel(emptyMessage));
            return;
        }
        this.editor.setGridView(new SelectionView());
        ControlsManager.pushOverride(this.selectInputOverride);
        int count = 0;
        for (Item i2 : this.canidateItems) {
            if (count % 4 == 0) {
                this.row();
            }
            ++count;
            SelectableItemSlot selectableSlot = new SelectableItemSlot(i2);
            this.itemSlotMap.put(i2.getID(), selectableSlot);
            selectableSlot.setOnSelect(item -> {
                this.selectItem((Item)item);
                return null;
            });
            selectableSlot.setOnDeselect(item -> {
                this.deselectItem((Item)item);
                return null;
            });
            for (SelectedItem si : this.selected) {
                if (si.getItem() == null || i2.getID() != si.getItem().getID()) continue;
                selectableSlot.setSelected(true);
            }
            this.add(selectableSlot);
        }
    }

    public GridView getGridView() {
        return new SelectionView();
    }

    public InputOverride getInputOverride() {
        return this.selectInputOverride;
    }

    public ItemSelectUI(Array<Item> potentialItems, SelectedItem selection, String emptyMessage, LevelEditorScreen editor) {
        this(potentialItems, emptyMessage, Array.with(selection), false, editor);
    }

    @Override
    public void handle() {
        this.editor.clearGridView();
        ControlsManager.popOverride(this.selectInputOverride);
        this.selected.forEach(si -> {
            if (si.i != null) {
                si.i.setSelected(false);
            }
        });
    }

    public static class SelectedItem {
        Item i;

        public boolean equals(Object obj) {
            if (obj instanceof SelectedItem) {
                Item i = ((SelectedItem)SelectedItem.class.cast((Object)obj)).i;
                return i != null && this.i != null && i.getID() == this.i.getID();
            }
            return false;
        }

        public SelectedItem(Item i) {
            this.i = i;
        }

        public SelectedItem() {
            this.i = null;
        }

        public void setItem(Item i) {
            this.i = i;
        }

        public Item getItem() {
            return this.i;
        }

        public SelectedItem clone() {
            return new SelectedItem(this.i);
        }
    }

    private class SelectInputOverride
    implements InputOverride {
        private final HashSet<Input> overriddenInputs = new HashSet<Input>(Set.of(Input.SELECT, Input.SELECT_MULTI));

        private SelectInputOverride() {
        }

        private boolean handleSelect(int x, int y) {
            Optional<Item> maybeTarget = ItemSelectUI.this.editor.priorityItemAt(x, y);
            if (maybeTarget.isEmpty()) {
                return true;
            }
            Item target = maybeTarget.get();
            if (ItemSelectUI.this.selected.contains(new SelectedItem(target), false)) {
                ItemSelectUI.this.deselectItem(target);
            } else if (ItemSelectUI.this.canidateItems.contains(target, false)) {
                ItemSelectUI.this.selectItem(target);
            }
            return true;
        }

        private boolean handleSelectMulti(int x, int y) {
            Optional<Item> maybeTarget = ItemSelectUI.this.editor.priorityItemAt(x, y);
            if (maybeTarget.isEmpty()) {
                return true;
            }
            Item target = maybeTarget.get();
            if (ItemSelectUI.this.selected.contains(new SelectedItem(target), false)) {
                ItemSelectUI.this.deselectItem(target);
            } else if (ItemSelectUI.this.canidateItems.contains(target, false)) {
                ItemSelectUI.this.selectItem(target);
            }
            return true;
        }

        @Override
        public boolean handleInput(Input input, ControlsManager.InputType type) {
            if (type != ControlsManager.InputType.PRESSED || !ItemSelectUI.this.editor.shouldHandleTouchDown()) {
                return false;
            }
            Vector2 screenCoords = new Vector2(Gdx.input.getX(), Gdx.input.getY());
            Types.IntVector2 gameCoords = Types.IntVector2.fromVector2(ItemSelectUI.this.editor.screenToStageCoordinates(screenCoords));
            switch (input) {
                case SELECT: {
                    return this.handleSelect(gameCoords.x, gameCoords.y);
                }
                case SELECT_MULTI: {
                    return this.handleSelectMulti(gameCoords.x, gameCoords.y);
                }
            }
            return false;
        }

        @Override
        public Set<Input> getOverriddenInputs() {
            return this.overriddenInputs;
        }
    }

    private class SelectionView
    implements GridView {
        private SelectionView() {
        }

        @Override
        public ItemDecoration decorate(Item item) {
            ItemDecoration decoration = new ItemDecoration();
            if (ItemSelectUI.this.selected.contains(new SelectedItem(item), false)) {
                decoration.set(ItemDecoration.COLOR, new Color(0.5f, 1.0f, 0.5f, 1.0f));
                decoration.set(ItemDecoration.HIGHTLIGHT, true);
            } else if (ItemSelectUI.this.canidateItems.contains(item, false)) {
                decoration.set(ItemDecoration.COLOR, new Color(1.0f, 1.0f, 1.0f, 1.0f));
                decoration.set(ItemDecoration.HIGHTLIGHT, true);
            } else {
                decoration.set(ItemDecoration.DIMMED, true);
            }
            return decoration;
        }
    }
}

