/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Scaling;
import group24.escaperoom.AssetManager;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.Player;
import group24.escaperoom.ui.ActionDialog;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.Tooltip;
import java.util.Optional;

public class ItemSlot
extends Container<ItemSlotInner> {
    protected ItemSlotInner inner;

    public ItemSlot(Item item) {
        this(Optional.of(item));
    }

    public ItemSlot() {
        this(Optional.empty());
    }

    protected ItemSlot(Optional<Item> item) {
        this.minSize(30.0f, 30.0f);
        this.inner = new ItemSlotInner(item);
        this.setActor(this.inner);
    }

    public static class ItemSlotInner
    extends Stack {
        Image selection = new Image(AssetManager.instance().getRegion("selection_outline"));
        Optional<ItemSlotValues> slotValues = Optional.empty();

        protected Item removeItem() {
            if (this.slotValues.isPresent()) {
                ItemSlotValues iv = this.slotValues.get();
                Item i = iv.item;
                iv.itemPreview.remove();
                this.slotValues = Optional.empty();
                return i;
            }
            return null;
        }

        protected void setItem(Item item) {
            ItemSlotValues iv = new ItemSlotValues(item);
            this.add(iv.itemPreview);
            new Tooltip.Builder(new SmallLabel(item.getItemName() + " ID " + item.getID(), "bubble_gray", 0.65f)).target(iv.itemPreview, Tooltip.stageHelper(this)).build();
            this.slotValues = Optional.of(iv);
        }

        public ItemSlotInner(Optional<Item> item) {
            Image bkg = new Image(AssetManager.instance().getRegion("empty_container_slot"));
            this.add(bkg);
            this.selection.setTouchable(Touchable.disabled);
            item.ifPresent(i -> this.setItem((Item)i));
        }

        public void onHover() {
            this.add(this.selection);
        }

        public void onHoverExit() {
            this.slotValues.ifPresentOrElse(i -> {
                if (!i.selected) {
                    this.selection.remove();
                }
            }, () -> this.selection.remove());
        }

        public void toggleSelectionOutline() {
            this.slotValues.ifPresent(i -> {
                if (i.selected) {
                    this.selection.remove();
                } else {
                    this.add(this.selection);
                }
                i.selected = !i.selected;
            });
        }

        public boolean isSelected() {
            return this.slotValues.map(sv -> sv.selected).orElse(false);
        }

        public void onClick(Player actingPlayer, Stage uiStage) {
            this.slotValues.ifPresent(sv -> new ActionDialog(sv.item, actingPlayer).show(uiStage));
        }

        protected static class ItemSlotValues {
            Item item;
            Image itemPreview;
            boolean selected = false;

            ItemSlotValues(Item item) {
                this.item = item;
                TextureRegionDrawable trd = new TextureRegionDrawable(item.getTexture());
                trd.setMinWidth(16 * item.getWidth());
                trd.setMinHeight(16 * item.getHeight());
                this.itemPreview = new Image(trd, Scaling.fit);
            }
        }
    }
}

