/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.Input;
import group24.escaperoom.control.MapGroup;
import group24.escaperoom.ui.SmallLabel;
import java.util.Arrays;

public class KeyMapTable
extends Container<ScrollPane> {
    Table inner = new Table();

    public KeyMapTable() {
        ControlsManager.InputGroupMap keymaps = ControlsManager.registedMappings();
        MapGroup[] groups = keymaps.keySet().toArray(new MapGroup[0]);
        Arrays.sort((Object[])groups);
        this.inner.defaults().left().expandX();
        for (MapGroup group : groups) {
            if (group == MapGroup.DEBUG) continue;
            this.inner.add(new SmallLabel(group.toString(), "title", 1.0f)).center().colspan(2).row();
            for (Input input : (Array)keymaps.get((Object)group)) {
                Input.MappingDescription desc = input.description();
                this.inner.add(new SmallLabel(desc.desc, "bubble"));
                HorizontalGroup hg = new HorizontalGroup();
                hg.space(5.0f);
                Arrays.stream(desc.bindings).forEach(bind -> hg.addActor(new SmallLabel((String)bind, "bubble_gray")));
                this.inner.add(hg).row();
            }
        }
        final ScrollPane scrollPane = new ScrollPane((Actor)this.inner);
        scrollPane.addListener(new InputListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (KeyMapTable.this.getStage() == null) {
                    return;
                }
                KeyMapTable.this.getStage().setScrollFocus(scrollPane);
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                if (KeyMapTable.this.getStage() == null) {
                    return;
                }
                KeyMapTable.this.getStage().setScrollFocus(null);
            }
        });
        this.setActor(scrollPane);
        this.maxHeight(400.0f);
    }
}

