/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.Scaling;
import group24.escaperoom.AssetManager;
import group24.escaperoom.data.MapManager;
import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.widgets.G24Dialog;
import group24.escaperoom.ui.widgets.G24TextButton;

public class MapStatDialog
extends G24Dialog {
    Container<Image> thumbnailContainer;
    MapMetadata metadata;

    public MapStatDialog(MapMetadata met, MapMetadata.MapStats stats) {
        super(met.name);
        this.metadata = met;
        Table t = this.getContentTable();
        VerticalGroup statGroup = new VerticalGroup();
        statGroup.addActor(new StatRow("Creator", stats.creator));
        statGroup.addActor(new StatRow("Downloads", Long.toString(stats.downloads)));
        statGroup.addActor(new StatRow("Attempts", Long.toString(stats.attempts)));
        statGroup.addActor(new StatRow("Clears", Long.toString(stats.clears)));
        statGroup.addActor(new StatRow("Upvotes", Long.toString(stats.upvotes)));
        statGroup.addActor(new StatRow("Downvotes", Long.toString(stats.downvotes)));
        statGroup.space(10.0f);
        statGroup.columnLeft();
        statGroup.padTop(20.0f);
        VerticalGroup wrGroup = new VerticalGroup();
        wrGroup.addActor(new StatRow("Record Holder", stats.record.username));
        if (stats.record.fastestms == -1L) {
            wrGroup.addActor(new StatRow("Time Taken", "No Record"));
        } else {
            long ms = stats.record.fastestms;
            long minutes = ms / 60000L;
            long seconds = (ms -= minutes * 1000L * 60L) / 1000L;
            wrGroup.addActor(new StatRow("Fastest Clear", String.format("%d:%02d:%03d", minutes, seconds, ms -= seconds * 1000L)));
        }
        wrGroup.space(10.0f);
        wrGroup.columnLeft();
        wrGroup.padTop(20.0f);
        t.row();
        Stack thumbnailStack = new Stack();
        thumbnailStack.setSize(220.0f, 220.0f);
        AssetManager.instance().load("textures/bkg.9.png", Texture.class);
        AssetManager.instance().finishLoadingAsset("textures/bkg.9.png");
        Texture bkg = AssetManager.instance().get("textures/bkg.9.png", Texture.class);
        NinePatch ninePatch = new NinePatch(bkg, 10, 10, 10, 10);
        NinePatchDrawable drawable = new NinePatchDrawable(ninePatch);
        Image bkgImg = new Image(drawable);
        bkgImg.setTouchable(Touchable.disabled);
        thumbnailStack.add(bkgImg);
        AssetManager.instance().load("textures/test_thumbnail.png", Texture.class);
        AssetManager.instance().finishLoadingAsset("textures/test_thumbnail.png");
        Image thumbnail = new Image(AssetManager.instance().get("textures/test_thumbnail.png", Texture.class));
        thumbnail.setScaling(Scaling.fit);
        this.thumbnailContainer = new Container<Image>(thumbnail);
        this.thumbnailContainer.setSize(220.0f, 220.0f);
        this.thumbnailContainer.pad(10.0f);
        thumbnailStack.add(this.thumbnailContainer);
        t.add(thumbnailStack).top().pad(20.0f).size(220.0f, 220.0f);
        if (stats.description.isEmpty()) {
            stats.description = "<no description provided by creator>";
        }
        VerticalGroup desc = new VerticalGroup();
        desc.space(10.0f);
        desc.columnLeft();
        SmallLabel titleLabel = new SmallLabel("Description", "title", 0.65f);
        desc.addActor(titleLabel);
        SmallLabel descLabel = new SmallLabel(stats.description, "default", 0.65f);
        descLabel.setWrap(true);
        descLabel.setAlignment(8);
        Container<SmallLabel> descWrap = new Container<SmallLabel>(descLabel);
        descWrap.width(300.0f);
        descWrap.left();
        desc.addActor(descWrap);
        t.add(desc).left().top().padTop(20.0f).padRight(10.0f);
        t.row();
        t.add(new SmallLabel("Map Statstics", "title")).center();
        t.add(new SmallLabel("World Record", "title")).center();
        t.row();
        t.add(statGroup).minWidth(200.0f).top();
        t.add(wrGroup).minWidth(200.0f).top();
        this.button(new G24TextButton("Done"));
    }

    @Override
    public Dialog show(Stage stage) {
        Dialog d = super.show(stage);
        System.out.println(this.metadata.locations.mapBasePath);
        this.waitFor(MapManager.fetchThumbnail(this.metadata), oPath -> {
            oPath.ifPresent(p -> MapManager.loadThumbNail(p).ifPresent(i -> {
                i.setScaling(Scaling.fit);
                this.thumbnailContainer.setActor((Image)i);
            }));
            return null;
        });
        return d;
    }

    public static class StatRow
    extends HorizontalGroup {
        public StatRow(String label, String value) {
            this(label, (Actor)new SmallLabel(value, "default", 0.6f));
        }

        public StatRow(String label, Actor value) {
            SmallLabel name = new SmallLabel(label + ":", "bubble", 0.6f);
            this.space(10.0f);
            this.addActor(name);
            this.addActor(value);
        }
    }
}

