/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.Notification;
import group24.escaperoom.data.NotificationBus;
import group24.escaperoom.ui.SmallLabel;

public class NotificationOverlay
extends Table
implements NotificationBus.NotificationListener {
    private final Array<Toast> activeNotifiations = new Array();

    @Override
    public void onNotify(Notification notification) {
        Toast toast = new Toast(notification);
        this.showToast(toast);
    }

    private void showToast(Toast toast) {
        this.activeNotifiations.add(toast);
        this.add(toast).right().pad(4.0f);
        this.row();
        if (toast.notification.getSource() != null) {
            toast.notification.getSource().addAction(Actions.sequence((Action)Actions.color(new Color(1.0f, 0.0f, 0.0f, 1.0f), 0.2f), (Action)Actions.color(new Color(1.0f, 0.0f, 0.0f, 0.5f), 0.2f), (Action)Actions.color(new Color(1.0f, 1.0f, 1.0f, 1.0f), 0.2f)));
        }
        if (!toast.notification.isPersistent()) {
            this.addAction(Actions.sequence((Action)Actions.delay(toast.notification.getDuration()), (Action)Actions.run(() -> this.removeToast(toast))));
        }
    }

    public NotificationOverlay() {
        this.setFillParent(true);
        this.align(18);
        this.pad(10.0f);
        NotificationBus.get().addListener(this);
    }

    private void removeToast(Toast toast) {
        this.activeNotifiations.removeValue(toast, false);
        if (this.activeNotifiations.isEmpty()) {
            this.clear();
        }
        toast.remove();
    }

    private static class Toast
    extends Container<SmallLabel> {
        final Notification notification;

        Toast(Notification notif) {
            this.notification = notif;
            this.setActor(new SmallLabel(this.notification.getMessage(), "bubble"));
        }
    }
}

