/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.Player;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.ui.PlayerInventoryCloseButton;
import group24.escaperoom.ui.PlayerInventoryItemSlot;
import group24.escaperoom.ui.widgets.G24Dialog;
import java.util.logging.Logger;

public class PlayerInventoryDialog
extends G24Dialog {
    Logger log = Logger.getLogger(PlayerInventoryDialog.class.getName());
    Player player;

    public PlayerInventoryDialog(Player player) {
        super("Player Inventory");
        this.player = player;
        Array<Item> inventory = player.getInventory();
        this.populateContentTable(inventory);
        this.button(new PlayerInventoryCloseButton("Close Inventory", player));
        this.setModal(false);
    }

    public void inventoryChanged() {
        this.getContentTable().clear();
        this.populateContentTable(this.player.getInventory());
        this.setPosition(Math.round((this.player.getGameScreen().getUIStage().getWidth() - this.getWidth()) / 2.0f), 10.0f);
    }

    @Override
    public Dialog show(Stage stage) {
        this.show(stage, Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.fadeIn(0.4f, Interpolation.fade)));
        this.setPosition(Math.round((this.player.getGameScreen().getUIStage().getWidth() - this.getWidth()) / 2.0f), 10.0f);
        BackManager.addBack(() -> {
            this.player.setInventoryOpen(false);
            this.hide();
        });
        return this;
    }

    private void populateContentTable(Array<Item> inventory) {
        Table tableOfItems = new Table(AbstractScreen.skin);
        tableOfItems.padLeft(10.0f);
        tableOfItems.padRight(10.0f);
        for (int k = 0; k < inventory.size; ++k) {
            tableOfItems.add(new PlayerInventoryItemSlot(inventory.get(k), this.player));
        }
        tableOfItems.add(new PlayerInventoryItemSlot(this.player));
        tableOfItems.pack();
        this.getContentTable().add(tableOfItems);
        this.getContentTable().pack();
        this.pack();
    }
}

