/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.player.Player;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.ui.InteractableItemSlot;
import group24.escaperoom.ui.dnd.ItemPayload;
import java.util.Optional;
import java.util.logging.Logger;

public class PlayerInventoryItemSlot
extends InteractableItemSlot {
    Logger log = Logger.getLogger("PlayerInventoryItemSlot");
    PlayerInventorySource source;
    PlayerInventoryTarget target;

    public PlayerInventoryItemSlot(Player actingPlayer) {
        super(actingPlayer);
        this.target = new PlayerInventoryTarget(this);
        actingPlayer.getGameScreen().getDragAndDrop().addTarget(this.target);
    }

    public PlayerInventoryItemSlot(Item item, Player actingPlayer) {
        super(Optional.of(item), actingPlayer);
        this.source = new PlayerInventorySource(this);
        actingPlayer.getGameScreen().getDragAndDrop().addSource(this.source);
    }

    @Override
    public void setItem(Item i) {
        super.setItem(i);
        if (this.source == null) {
            this.source = new PlayerInventorySource(this);
        }
        this.actingPlayer.getGameScreen().getDragAndDrop().addSource(this.source);
        this.actingPlayer.getGameScreen().getDragAndDrop().removeTarget(this.target);
        this.actingPlayer.addItemToInventory(i);
    }

    @Override
    public Item removeItemFromSlot() {
        Item removed = super.removeItemFromSlot();
        this.actingPlayer.getGameScreen().getDragAndDrop().removeSource(this.source);
        if (this.target == null) {
            this.target = new PlayerInventoryTarget(this);
        }
        this.actingPlayer.getGameScreen().getDragAndDrop().addTarget(this.target);
        this.actingPlayer.removeItemFromInventory(removed);
        return removed;
    }

    public class PlayerInventoryTarget
    extends DragAndDrop.Target {
        public PlayerInventoryTarget(PlayerInventoryItemSlot slot) {
            super(slot);
        }

        @Override
        public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            PlayerInventoryItemSlot.this.inner.onHover();
            return true;
        }

        @Override
        public void reset(DragAndDrop.Source source, DragAndDrop.Payload payload) {
            PlayerInventoryItemSlot.this.inner.onHoverExit();
        }

        @Override
        public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            if (source instanceof PlayerInventorySource) {
                return;
            }
            Item i = ((ItemPayload)ItemPayload.class.cast(payload)).getItem();
            PlayerInventoryItemSlot.this.setItem(i);
        }
    }

    public class PlayerInventorySource
    extends DragAndDrop.Source {
        PlayerInventorySource(PlayerInventoryItemSlot slot) {
            super(slot);
            slot.addListener(CursorManager.hoverHelper(CursorManager.CursorType.Hand));
        }

        @Override
        public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
            PlayerInventoryItemSlot.this.inner.slotValues.get().itemPreview.setVisible(false);
            return new ItemPayload(PlayerInventoryItemSlot.this.inner.slotValues.get().item);
        }

        @Override
        public void dragStop(InputEvent event, float x, float y, int pointer, @Null DragAndDrop.Payload payload, @Null DragAndDrop.Target target) {
            if (target == null || target instanceof PlayerInventoryTarget) {
                PlayerInventoryItemSlot.this.inner.slotValues.get().itemPreview.setVisible(true);
            } else {
                PlayerInventoryItemSlot.this.removeItemFromSlot();
            }
            CursorManager.restoreDefault();
        }
    }
}

