/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.GridView;
import group24.escaperoom.screens.editor.ItemDecoration;
import group24.escaperoom.ui.RequiredItemEntry;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import java.util.Collection;
import java.util.HashMap;

public class RequireItemsUI
extends Container<ScrollPane>
implements ConfigurationMenu.HandlesMenuClose {
    private LevelEditorScreen editor;
    private HashMap<Integer, Item> canidates = new HashMap();
    private HashMap<Integer, RequiredItemEntry.RequiredItem> selected = new HashMap();

    public RequireItemsUI(Array<Item> potentialItems, Array<RequiredItemEntry.RequiredItem> mutCurrentSelection, LevelEditorScreen editor) {
        this.editor = editor;
        editor.setGridView(new RequiresItemsView());
        Table inner = new Table();
        inner.padLeft(20.0f);
        inner.defaults().left().expandX().pad(2.0f);
        for (Item potentialItem : potentialItems) {
            RequiredItemEntry entry = null;
            boolean found = false;
            this.canidates.put(potentialItem.getID(), potentialItem);
            for (RequiredItemEntry.RequiredItem selectedItem : mutCurrentSelection) {
                if (selectedItem.getItem().getID() != potentialItem.getID()) continue;
                found = true;
                entry = new RequiredItemEntry(selectedItem.getItem(), selectedItem.getRequired());
                this.selected.put(potentialItem.getID(), selectedItem);
                break;
            }
            if (!found) {
                entry = new RequiredItemEntry(potentialItem, RequiredItemEntry.ItemRequired.Either);
            }
            entry.setOnChanged(RequiredItemEntry.onChangeHelper(mutCurrentSelection, this.selected));
            inner.add(entry.slot);
            inner.add(entry.label);
            inner.add(entry.checkBtn);
            inner.add(entry.forbidBtn);
            inner.row();
        }
        inner.pack();
        ScrollPane scroll = new ScrollPane((Actor)inner);
        scroll.setFadeScrollBars(false);
        scroll.setScrollBarPositions(false, false);
        scroll.setForceScroll(false, true);
        this.maxHeight(300.0f);
        this.setActor(scroll);
        this.pack();
    }

    @Override
    public void handle() {
        this.editor.clearGridView();
    }

    private class RequiresItemsView
    implements GridView {
        private RequiresItemsView() {
        }

        @Override
        public void apply(Collection<Item> items) {
            for (Item i : items) {
                if (RequireItemsUI.this.canidates.containsKey(i.getID())) continue;
                i.setDimmed(true);
            }
            for (Item i : RequireItemsUI.this.canidates.values()) {
                if (RequireItemsUI.this.selected.containsKey(i.getID())) {
                    switch (((RequiredItemEntry.RequiredItem)((RequireItemsUI)RequireItemsUI.this).selected.get((Object)Integer.valueOf((int)i.getID()))).required) {
                        case Either: {
                            i.setColor(Color.WHITE);
                            break;
                        }
                        case Forbidden: {
                            i.setColor(Color.RED);
                            break;
                        }
                        case Yes: {
                            i.setColor(Color.GREEN);
                        }
                    }
                    continue;
                }
                i.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
            }
        }

        @Override
        public void reset(Collection<Item> items) {
            for (Item i : items) {
                if (!RequireItemsUI.this.canidates.containsKey(i.getID())) {
                    i.setDimmed(false);
                }
                if (!RequireItemsUI.this.selected.containsKey(i.getID())) continue;
                i.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
            }
        }

        @Override
        public ItemDecoration decorate(Item item) {
            ItemDecoration decoration = new ItemDecoration();
            if (!RequireItemsUI.this.canidates.containsKey(item.getID())) {
                decoration.set(ItemDecoration.DIMMED, true);
                return decoration;
            }
            if (RequireItemsUI.this.selected.containsKey(item.getID())) {
                Color c = Color.WHITE;
                switch (((RequiredItemEntry.RequiredItem)((RequireItemsUI)RequireItemsUI.this).selected.get((Object)Integer.valueOf((int)item.getID()))).required) {
                    case Either: {
                        c = Color.YELLOW;
                        break;
                    }
                    case Forbidden: {
                        c = Color.RED;
                        break;
                    }
                    case Yes: {
                        c = Color.GREEN;
                    }
                }
                decoration.set(ItemDecoration.COLOR, c);
                return decoration;
            }
            return null;
        }
    }
}

