/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.ui.ItemSlot;
import group24.escaperoom.ui.SmallLabel;
import java.util.HashMap;

public class RequiredItemEntry {
    private RequiredItemChanged callBack = i -> {};
    private ButtonGroup<RequireButton> buttonGroup;
    private Item item;
    public final ItemSlot slot;
    public final SmallLabel label;
    public final RequireButton checkBtn;
    public final RequireButton forbidBtn;

    public static RequiredItemChanged onChangeHelper(Array<RequiredItem> mutArr, HashMap<Integer, RequiredItem> mutSelected) {
        return item -> {
            if (item.getRequired() == ItemRequired.Either) {
                mutArr.removeValue(item, false);
                mutSelected.remove(item.item.getID());
            }
            boolean found = false;
            for (RequiredItem ti : mutArr) {
                if (ti.getItem().getID() != item.getItem().getID()) continue;
                ti.setRequired(item.getRequired());
                found = true;
            }
            if (!found) {
                mutArr.add(item);
                mutSelected.put(item.item.getID(), item);
            }
        };
    }

    public void setOnChanged(RequiredItemChanged callback) {
        this.callBack = callback;
    }

    public RequiredItemEntry(Item item, ItemRequired required) {
        this.item = item;
        this.slot = new ItemSlot(item);
        this.label = new SmallLabel(item.getItemName());
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.setMaxCheckCount(1);
        this.buttonGroup.setMinCheckCount(0);
        this.checkBtn = new RequireButton("toggleRequired", ItemRequired.Yes);
        this.forbidBtn = new RequireButton("toggleForbidden", ItemRequired.Forbidden);
        this.checkBtn.setChecked(required == ItemRequired.Yes);
        this.forbidBtn.setChecked(required == ItemRequired.Forbidden);
        this.buttonGroup.add((RequireButton)new RequireButton[]{this.checkBtn, this.forbidBtn});
    }

    private void updateProperty() {
        RequiredItem ti = new RequiredItem(this.item, ItemRequired.Either);
        RequireButton tb = this.buttonGroup.getChecked();
        if (tb != null) {
            ti.setRequired(tb.req);
        }
        this.callBack.onChange(ti);
    }

    public static interface RequiredItemChanged {
        public void onChange(RequiredItem var1);
    }

    private class RequireButton
    extends ImageButton {
        ItemRequired req;
        private ChangeListener buttonListener;

        public RequireButton(String style, ItemRequired setsRequired) {
            super(AbstractScreen.skin, style);
            this.buttonListener = new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    RequiredItemEntry.this.updateProperty();
                }
            };
            this.req = setsRequired;
            this.addListener(this.buttonListener);
            this.setProgrammaticChangeEvents(false);
        }
    }

    public static enum ItemRequired {
        Yes,
        Forbidden,
        Either;


        public boolean matches(boolean isRequired) {
            switch (this) {
                case Either: {
                    return true;
                }
                case Forbidden: {
                    return !isRequired;
                }
                case Yes: {
                    return isRequired;
                }
            }
            return false;
        }
    }

    public static class RequiredItem {
        ItemRequired required;
        Item item;

        public RequiredItem(Item item, ItemRequired required) {
            this.item = item;
            this.required = required;
        }

        public Item getItem() {
            return this.item;
        }

        public void setRequired(ItemRequired required) {
            this.required = required;
        }

        public ItemRequired getRequired() {
            return this.required;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RequiredItem) {
                return ((RequiredItem)RequiredItem.class.cast((Object)obj)).item.getID() == this.item.getID();
            }
            return false;
        }
    }
}

