/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.entities.Item;
import group24.escaperoom.ui.ItemSlot;
import java.util.Optional;
import java.util.function.Function;

public class SelectableItemSlot
extends ItemSlot {
    Function<Item, Void> onSelect = i -> null;
    Function<Item, Void> onDeselect = i -> null;

    public SelectableItemSlot() {
        super(Optional.empty());
    }

    public SelectableItemSlot(Item item) {
        this(Optional.of(item));
    }

    public void setOnSelect(Function<Item, Void> callBack) {
        this.onSelect = callBack;
    }

    public void setOnDeselect(Function<Item, Void> callBack) {
        this.onDeselect = callBack;
    }

    public void setSelected(boolean select) {
        this.inner.slotValues.ifPresent(sv -> {
            if (select != sv.selected) {
                this.inner.toggleSelectionOutline();
            }
        });
    }

    public void toggleSelect() {
        this.inner.slotValues.ifPresent(i -> this.setSelected(!i.selected));
    }

    public SelectableItemSlot(Optional<Item> item) {
        super(item);
        item.ifPresent(i -> {
            this.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    SelectableItemSlot.this.toggleSelect();
                    SelectableItemSlot.this.inner.slotValues.ifPresent(sv -> {
                        if (sv.selected) {
                            SelectableItemSlot.this.onSelect.apply(sv.item);
                        } else {
                            SelectableItemSlot.this.onDeselect.apply(sv.item);
                        }
                    });
                }
            });
            this.addListener(new InputListener(){

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, @Null Actor fromActor) {
                    SelectableItemSlot.this.inner.onHover();
                }

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, @Null Actor toActor) {
                    SelectableItemSlot.this.inner.onHoverExit();
                }
            });
        });
    }
}

