/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.scenes.scene2d.ui.Table;
import group24.escaperoom.data.GameStatistics;
import group24.escaperoom.ui.widgets.G24Label;

public class StatTable
extends Table {
    public StatTable(GameStatistics stats) {
        this.defaults().pad(30.0f);
        if (stats.completedSucessfully) {
            this.add(new G24Label("Map Completed!", "title")).colspan(2);
        } else {
            this.add(new G24Label("You Surrendered", "bubble")).colspan(2);
        }
        long ms = stats.timeMilliseconds;
        long minutes = ms / 60000L;
        long seconds = (ms -= minutes * 1000L * 60L) / 1000L;
        this.addLabel("Time taken", String.format("%d:%02d.%03d", minutes, seconds, ms -= seconds * 1000L), "");
        this.addLabel("Distance traveled", String.format("%.2f", Float.valueOf(stats.player.distanceTraveled)), "m");
        this.addLabel("Average Speed", String.format("%.2f", Float.valueOf(stats.player.avgSpeed)), "m/s");
        this.addLabel("Actions Performed", stats.player.actionsPerformed, "actions");
        this.addLabel("Items collected", stats.player.itemsCollected, "items");
    }

    private <T> void addLabel(String label, T value, String suffix) {
        this.row();
        this.add(new G24Label(label + ":", "bubble")).center().expandX();
        this.add(new G24Label(value.toString() + " " + suffix, "white")).left();
    }
}

