/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Timer;
import group24.escaperoom.entities.Item;
import group24.escaperoom.ui.SmallLabel;
import java.util.Optional;
import java.util.function.Function;

public class Tooltip
extends Table {
    public static float DEFAULT_FADE_TIME = 0.3f;
    public static float DEFAULT_APPEAR_DELAY = 0.8f;
    public static Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private Actor target;
    private Actor content;
    private Builder.LazyUIStage getUiStage;
    DisplayTask displayTask;
    TooltipInputListener listener;

    private Tooltip(Builder builder) {
        this.init(builder.target, builder.uiStage, builder.content);
    }

    private void init(Actor target, Builder.LazyUIStage uiStage, Actor content) {
        this.target = target;
        this.content = content;
        this.getUiStage = uiStage;
        this.listener = new TooltipInputListener();
        this.displayTask = new DisplayTask();
        this.add(content).padLeft(3.0f).padRight(3.0f).padBottom(2.0f);
        this.pack();
        this.attach();
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                Tooltip.this.toFront();
                return true;
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (pointer == -1) {
                    Tooltip.this.clearActions();
                    Tooltip.this.addAction(Actions.sequence((Action)Actions.fadeIn(DEFAULT_FADE_TIME, Interpolation.fade)));
                }
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                if (pointer == -1) {
                    Tooltip.this.fadeOut();
                }
            }
        });
    }

    private void attach() {
        this.target.addListener(this.listener);
    }

    private void fadeOut() {
        this.clearActions();
        this.addAction(Actions.sequence((Action)Actions.fadeOut(DEFAULT_FADE_TIME, Interpolation.fade), (Action)Actions.removeActor()));
    }

    private Table fadeIn() {
        this.clearActions();
        this.setColor(color);
        this.addAction(Actions.sequence((Action)Actions.fadeIn(DEFAULT_FADE_TIME)));
        this.toFront();
        return this;
    }

    public static Builder.LazyUIStage stageHelper(Actor a) {
        return () -> {
            if (a.getStage() == null) {
                return Optional.empty();
            }
            return Optional.of(a.getStage());
        };
    }

    public static Function<Void, Optional<Stage>> stageHelperItem(Item a) {
        return Void2 -> {
            if (a.map.getUIStage() == null) {
                return Optional.empty();
            }
            return Optional.of(a.map.getUIStage());
        };
    }

    public static class Builder {
        private final Actor content;
        private Actor target = null;
        private LazyUIStage uiStage;

        public Builder(Actor content) {
            this.content = content;
        }

        public Builder(String text) {
            this(text, 1);
        }

        public Builder(String text, int align) {
            SmallLabel label = new SmallLabel(text, "bubble");
            label.setAlignment(align);
            this.content = label;
        }

        public Builder target(Actor target, LazyUIStage getUIStage) {
            this.target = target;
            this.uiStage = getUIStage;
            return this;
        }

        public Tooltip build() {
            return new Tooltip(this);
        }

        public static interface LazyUIStage {
            public Optional<Stage> apply();
        }
    }

    private class TooltipInputListener
    extends InputListener {
        private TooltipInputListener() {
        }

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            Tooltip.this.displayTask.cancel();
            Tooltip.this.toFront();
            Tooltip.this.fadeOut();
            return true;
        }

        @Override
        public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
            if (pointer == -1) {
                Tooltip.this.getUiStage.apply().ifPresent(uiStage -> {
                    Vector2 targetPos = Tooltip.this.target.localToScreenCoordinates(new Vector2(Tooltip.this.target.getWidth() / 2.0f, 0.0f));
                    targetPos = uiStage.getViewport().unproject(targetPos);
                    Tooltip.this.setX(targetPos.x);
                    float stageHeight = uiStage.getHeight();
                    if (stageHeight - Tooltip.this.content.getHeight() > stageHeight) {
                        Tooltip.this.setY(targetPos.y + 6.0f);
                    } else {
                        Tooltip.this.setY(targetPos.y - 20.0f);
                    }
                    Tooltip.this.displayTask.cancel();
                    Timer.schedule(Tooltip.this.displayTask, DEFAULT_APPEAR_DELAY);
                });
            }
        }

        @Override
        public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
            if (pointer == -1) {
                Tooltip.this.displayTask.cancel();
                Tooltip.this.fadeOut();
            }
        }

        @Override
        public boolean mouseMoved(InputEvent event, float x, float y) {
            if (Tooltip.this.isVisible() && Tooltip.this.getActions().size == 0) {
                Tooltip.this.fadeOut();
            }
            return false;
        }
    }

    private class DisplayTask
    extends Timer.Task {
        private DisplayTask() {
        }

        @Override
        public void run() {
            Tooltip.this.getUiStage.apply().ifPresent(uiStage -> {
                Table t = Tooltip.this.fadeIn();
                uiStage.addActor(t);
            });
        }
    }
}

