/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.conditionals;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;
import group24.escaperoom.AssetManager;
import group24.escaperoom.entities.properties.conditionals.Conditional;
import group24.escaperoom.entities.properties.conditionals.ConditionalProperty;
import group24.escaperoom.entities.properties.conditionals.ConditionalType;
import group24.escaperoom.entities.properties.conditionals.EmptyConditional;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.widgets.G24TextButton;
import java.util.Optional;
import java.util.logging.Logger;

public class ConditionalUI
extends Table
implements ConfigurationMenu.HandlesMenuClose {
    Logger log = Logger.getLogger(ConditionalUI.class.getName());
    private LevelEditorScreen editor;
    static int colorInd = 0;
    static final Color[] bkgColors = new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 1.0f, 1.0f), new Color(1.0f, 1.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 1.0f, 1.0f)};
    VerticalGroup conditionals = new VerticalGroup();
    DragAndDrop dragAndDrop = new DragAndDrop();
    WorkSpace workspace;
    ConditionalProperty property;
    Menu parent;

    public ConditionalUI(ConditionalProperty conditionalProperty, Menu parentMenu) {
        this.property = conditionalProperty;
        this.parent = parentMenu;
        this.editor = (LevelEditorScreen)this.parent.getScreen();
        this.defaults().left();
        this.conditionals.space(10.0f);
        for (Conditional cond : conditionalProperty.getPotentialValues()) {
            if (cond.getType() == ConditionalType.EmptyConditional) continue;
            ConditionalSource s = new ConditionalSource(cond);
            this.dragAndDrop.addSource(s);
            this.conditionals.addActor(s.getActor());
        }
        Container<VerticalGroup> condWrapper = new Container<VerticalGroup>(this.conditionals);
        condWrapper.padLeft(20.0f);
        condWrapper.minWidth(200.0f);
        condWrapper.pack();
        final ScrollPane scrollPane = new ScrollPane(condWrapper, AbstractScreen.skin, "default");
        scrollPane.setFadeScrollBars(false);
        scrollPane.setScrollBarPositions(false, false);
        scrollPane.setForceScroll(false, true);
        scrollPane.addListener(new InputListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                ConditionalUI.this.editor.getUIStage().setScrollFocus(scrollPane);
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                ConditionalUI.this.editor.getUIStage().setScrollFocus(null);
            }
        });
        Container<ScrollPane> wrapper = new Container<ScrollPane>(scrollPane);
        wrapper.pack();
        wrapper.maxHeight(200.0f);
        wrapper.minWidth(200.0f);
        this.dragAndDrop.addTarget(new DragAndDrop.Target(wrapper){

            @Override
            public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                return source instanceof ConditionalBlockSource;
            }

            @Override
            public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            }
        });
        Conditional c = conditionalProperty.getCurrentValue();
        this.workspace = new WorkSpace(c);
        final G24TextButton clearButton = new G24TextButton("Clear");
        clearButton.setProgrammaticChangeEvents(false);
        clearButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (clearButton.isChecked()) {
                    clearButton.setChecked(false);
                    ConditionalUI.this.workspace.clearRoot();
                }
            }
        });
        this.add(wrapper);
        this.add(this.workspace);
        this.row();
        this.add(clearButton);
    }

    private void setProperty() {
        this.workspace.pack();
        this.workspace.invalidateHierarchy();
        this.pack();
        this.parent.pack();
        this.workspace.rootBlock.ifPresentOrElse(rootBlock -> {
            Conditional cond = this.buildConditional((ConditionalBlock)rootBlock).get();
            this.property.set(cond);
        }, () -> this.property.set((Conditional)null));
    }

    private Optional<Conditional> buildConditional(ConditionalBlock block) {
        Conditional c = block.val;
        if (c.getType() == ConditionalType.EmptyConditional) {
            return Optional.empty();
        }
        SnapshotArray<Actor> children = block.children.getChildren();
        Array childConditionals = new Array(Conditional.class);
        for (int i = 0; i < children.size; ++i) {
            ConditionalBlock child = (ConditionalBlock)children.get(i);
            this.buildConditional(child).ifPresent(cond -> childConditionals.add(cond));
        }
        c.setChildren((Conditional[])childConditionals.toArray());
        return Optional.of(c);
    }

    @Override
    public void handle() {
    }

    private class ConditionalSource
    extends DragAndDrop.Source {
        Conditional c;

        public ConditionalSource(Conditional c) {
            super(new SmallLabel(c.getName(), "bubble", 0.65f));
            this.getActor().addListener(CursorManager.hoverHelper(CursorManager.CursorType.Hand));
            this.c = c;
        }

        @Override
        public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
            DragAndDrop.Payload p = new DragAndDrop.Payload();
            SmallLabel valid = new SmallLabel(this.c.getName(), "bubble", 0.65f);
            valid.setColor(0.75f, 1.0f, 0.75f, 0.5f);
            SmallLabel invalid = new SmallLabel(this.c.getName(), "bubble", 0.65f);
            invalid.setColor(1.0f, 0.75f, 0.75f, 0.5f);
            p.setValidDragActor(valid);
            p.setInvalidDragActor(invalid);
            p.setDragActor(valid);
            p.setObject(this.c.clone());
            return p;
        }

        @Override
        public void dragStop(InputEvent event, float x, float y, int pointer, DragAndDrop.Payload payload, DragAndDrop.Target target) {
            CursorManager.restoreDefault();
        }
    }

    private class WorkSpace
    extends Container<ConditionalBlock> {
        private Optional<ConditionalBlock> rootBlock = Optional.empty();
        DragAndDrop.Target rootTarg;

        public WorkSpace(Conditional root) {
            if (root == null) {
                this.setActor(new EmptyBlock());
            } else {
                this.rootBlock = Optional.of(new ConditionalBlock(root));
                this.setActor(this.rootBlock.get());
            }
            this.minSize(100.0f, 150.0f);
            AssetManager.instance().load("textures/bkg.9.png", Texture.class);
            AssetManager.instance().finishLoadingAsset("textures/bkg.9.png");
            Texture bkg = AssetManager.instance().get("textures/bkg.9.png", Texture.class);
            NinePatch ninePatch = new NinePatch(bkg, 10, 10, 10, 10);
            NinePatchDrawable drawable = new NinePatchDrawable(ninePatch);
            this.setBackground(drawable);
            this.rootTarg = new DragAndDrop.Target(this){

                @Override
                public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                    return !WorkSpace.this.rootBlock.isPresent();
                }

                @Override
                public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                    WorkSpace.this.setRootBlock(new ConditionalBlock((Conditional)payload.getObject()));
                    ConditionalUI.this.dragAndDrop.removeTarget(WorkSpace.this.rootTarg);
                }
            };
        }

        public void setRootBlock(ConditionalBlock block) {
            this.rootBlock = Optional.of(block);
            this.setActor(block);
            ConditionalUI.this.setProperty();
        }

        public void clearRoot() {
            this.rootBlock.ifPresent(r -> r.remove());
            ConditionalUI.this.dragAndDrop.addTarget(this.rootTarg);
            this.rootBlock = Optional.empty();
            this.setActor(new EmptyBlock());
            ConditionalUI.this.setProperty();
        }
    }

    private class ConditionalBlock
    extends Stack {
        HorizontalGroup children = new HorizontalGroup();
        VerticalGroup innerVGroup = new VerticalGroup();
        SmallLabel label;
        Conditional val;

        public boolean equals(Object obj) {
            if (obj instanceof ConditionalBlock) {
                return ((ConditionalBlock)ConditionalBlock.class.cast((Object)obj)).val.equals(this.val);
            }
            return false;
        }

        private ConditionalBlock() {
            this(new EmptyConditional());
        }

        private ConditionalBlock(final Conditional cond) {
            AssetManager.instance().load("textures/bkg.9.png", Texture.class);
            AssetManager.instance().finishLoadingAsset("textures/bkg.9.png");
            Texture bkg = AssetManager.instance().get("textures/bkg.9.png", Texture.class);
            NinePatch ninePatch = new NinePatch(bkg, 10, 10, 10, 10);
            NinePatchDrawable drawable = new NinePatchDrawable(ninePatch);
            Image bkgImg = new Image(drawable);
            bkgImg.setColor(bkgColors[colorInd]);
            colorInd = (colorInd + 1) % bkgColors.length;
            this.add(bkgImg);
            this.val = cond;
            this.innerVGroup.space(10.0f);
            this.innerVGroup.align(1);
            this.label = cond.getType() == ConditionalType.EmptyConditional ? new SmallLabel("<empty>", "bubble", 0.65f) : new SmallLabel(cond.getName(), "bubble", 0.65f);
            this.innerVGroup.addActor(this.label);
            if (cond.getType() != ConditionalType.EmptyConditional) {
                ConditionalUI.this.dragAndDrop.addSource(new ConditionalBlockSource(this));
            }
            this.label.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    cond.getEditorConfiguration(ConditionalUI.this.editor).ifPresent(conf -> ConditionalUI.this.parent.getParent().createNewMenu(new ConfigurationMenu<Actor>(ConditionalUI.this.parent.getParent(), (Actor)conf, cond.getName(), ConditionalUI.this.editor)));
                }
            });
            cond.childCount().ifPresentOrElse(count -> {
                if (count > 0) {
                    this.children.space(10.0f);
                    this.children.align(1);
                    Array<Conditional> childrenConds = this.val.getChildren();
                    for (int i = 0; i < count; ++i) {
                        if (i >= childrenConds.size || childrenConds.get(i).getType() == ConditionalType.EmptyConditional) {
                            this.children.addActor(new EmptyBlock());
                            continue;
                        }
                        this.children.addActor(new ConditionalBlock(childrenConds.get(i)));
                    }
                    this.innerVGroup.addActor(this.children);
                }
            }, () -> {
                this.children.space(10.0f);
                this.children.align(1);
                Array<Conditional> childrenConds = this.val.getChildren();
                for (int i = 0; i < childrenConds.size + 1; ++i) {
                    if (i >= childrenConds.size || childrenConds.get(i).getType() == ConditionalType.EmptyConditional) {
                        this.children.addActor(new EmptyBlock());
                        continue;
                    }
                    this.children.addActor(new ConditionalBlock(childrenConds.get(i)));
                }
                this.innerVGroup.addActor(this.children);
            });
            this.add(this.innerVGroup);
        }
    }

    private class ConditionalBlockSource
    extends DragAndDrop.Source {
        ConditionalBlock source;

        ConditionalBlockSource(ConditionalBlock source) {
            super(source.label);
            this.source = source;
            source.label.addListener(CursorManager.hoverHelper(CursorManager.CursorType.Hand));
        }

        @Override
        public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
            DragAndDrop.Payload p = new DragAndDrop.Payload();
            this.source.setVisible(false);
            SmallLabel valid = new SmallLabel(this.source.val.getName(), "bubble", 0.65f);
            valid.setColor(0.75f, 1.0f, 0.75f, 0.5f);
            SmallLabel invalid = new SmallLabel(this.source.val.getName(), "bubble", 0.65f);
            invalid.setColor(1.0f, 0.75f, 0.75f, 0.5f);
            p.setValidDragActor(valid);
            p.setInvalidDragActor(invalid);
            p.setDragActor(valid);
            return p;
        }

        @Override
        public void drag(InputEvent event, float x, float y, int pointer) {
        }

        @Override
        public void dragStop(InputEvent event, float x, float y, int pointer, DragAndDrop.Payload payload, DragAndDrop.Target target) {
            if (target == null) {
                this.source.setVisible(true);
                return;
            }
            if (this.source.getParent() instanceof HorizontalGroup) {
                HorizontalGroup parentChildren = (HorizontalGroup)this.source.getParent();
                SnapshotArray<Actor> blocks = parentChildren.getChildren();
                int thisInd = blocks.indexOf(this.source, false);
                ConditionalBlock cb = (ConditionalBlock)parentChildren.getParent().getParent();
                if (cb.val.childCount().isPresent()) {
                    parentChildren.addActorAt(thisInd, new EmptyBlock());
                }
                this.source.remove();
                ConditionalUI.this.setProperty();
            } else {
                ConditionalUI.this.workspace.clearRoot();
            }
            ConditionalUI.this.dragAndDrop.removeSource(this);
            CursorManager.restoreDefault();
        }
    }

    public class EmptyBlock
    extends ConditionalBlock {
        EmptyBlock() {
            ConditionalUI.this.dragAndDrop.addTarget(new DragAndDrop.Target(this){

                @Override
                public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                    return true;
                }

                @Override
                public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                    HorizontalGroup parentChildren = (HorizontalGroup)EmptyBlock.this.getParent();
                    ConditionalBlock parentCb = (ConditionalBlock)parentChildren.getParent().getParent();
                    SnapshotArray<Actor> blocks = parentChildren.getChildren();
                    int thisInd = blocks.indexOf(EmptyBlock.this, false);
                    parentChildren.addActorAt(thisInd, new ConditionalBlock((Conditional)payload.getObject()));
                    if (!parentCb.val.childCount().isEmpty()) {
                        EmptyBlock.this.remove();
                    }
                    ConditionalUI.this.setProperty();
                }
            });
        }
    }
}

