/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editor;

import com.badlogic.gdx.math.Vector2;
import group24.escaperoom.ScreenManager;
import group24.escaperoom.data.MapData;
import group24.escaperoom.data.MapSaver;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.screens.ItemEditor;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.editor.PropertyMenu;
import group24.escaperoom.ui.editorTools.DeletionTool;
import group24.escaperoom.ui.editorTools.EyeDropTool;
import group24.escaperoom.ui.editorTools.RotationTool;
import group24.escaperoom.utils.Notifier;

public class ItemMenu
extends Menu {
    Item item;

    public ItemMenu(Item target, LevelEditorScreen editor) {
        super(null, target.getItemName(), editor);
        this.item = target;
        Vector2 uiPos = editor.gameCoordToUI(this.item.getPosition().add(this.item.getWidth(), 1).asVector2());
        this.setPosition(uiPos.x, uiPos.y, 12);
        this.add(Menu.MenuEntry.label("ID: " + this.item.getID())).row();
        this.add(Menu.MenuEntry.divider()).row();
        if (target.getProperties().stream().anyMatch(p -> p.getInputType() != ItemProperty.MenuType.None)) {
            this.add(new Menu.MenuEntryBuilder((Menu)this, "Properties").spawns(parent -> new PropertyMenu(parent, this.item, editor)).build()).row();
            this.add(Menu.MenuEntry.divider()).row();
        }
        this.add(new Menu.MenuEntryBuilder((Menu)this, "Edit Item Instance").onClick(() -> {
            target.setSelected(false);
            if (MapSaver.saveMap(editor.grid, editor.getMetadata())) {
                ScreenManager.instance().showScreen(new ItemEditor(new MapData(editor.grid, editor.getMetadata()), target), true);
            } else {
                Notifier.error("Failed to save map");
            }
        }).build()).row();
        this.add(new Menu.MenuEntryBuilder((Menu)this, "Delete").onClick(() -> {
            this.close();
            this.item.remove(false);
            editor.recordEditorAction(new DeletionTool.Deletion(editor, this.item));
        }).build()).row();
        this.add(new Menu.MenuEntryBuilder((Menu)this, "Copy").onClick(() -> {
            EyeDropTool tool = (EyeDropTool)editor.getTool(ToolManager.ToolType.EyeDrop);
            editor.setActiveTool(tool);
            tool.copyItem(target);
            this.close();
        }).build()).row();
        this.add(new Menu.MenuEntryBuilder((Menu)this, "Rotate").onClick(() -> {
            this.item.rotateBy(90);
            editor.recordEditorAction(new RotationTool.RotationAction(this.item));
        }).build()).row();
        this.add(new Menu.MenuEntryBuilder((Menu)this, "Flip Horizontal").onClick(() -> this.item.mirrorHorizontal()).build()).row();
        this.add(new Menu.MenuEntryBuilder((Menu)this, "Flip Vertical").onClick(() -> this.item.mirrorVertical()).build()).row();
        this.pack();
        this.add(new Menu.MenuEntryBuilder((Menu)this, "Send forward").onClick(() -> this.item.increaseRenderPriotity()).build()).row();
        this.pack();
        this.add(new Menu.MenuEntryBuilder((Menu)this, "Send backward").onClick(() -> this.item.decreaseRenderPriotity()).build()).row();
        this.pack();
    }
}

