/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editor;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import group24.escaperoom.AssetManager;
import group24.escaperoom.data.MapLoader;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.ItemEditor;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.Tooltip;
import group24.escaperoom.ui.editor.PropertyWorkspace;
import group24.escaperoom.ui.editor.TexturePicker;
import group24.escaperoom.ui.widgets.G24NumberInput;
import group24.escaperoom.ui.widgets.G24TextButton;
import group24.escaperoom.ui.widgets.G24TextInput;
import group24.escaperoom.utils.Notifier;
import java.util.function.Function;

public class ItemSideBar
extends Table {
    public PropertyWorkspace workspace;
    private Function<Item, Void> init;

    public void populateFor(Item item) {
        this.init.apply(item);
        this.workspace.populateFor(item);
    }

    private void refreshItem() {
        ItemEditor.get().updateItemPosition();
        ItemEditor.get().markModified();
    }

    private G24TextInput nonEmptyStringField(String name, String value, String defaultValue, final ModifiesItemString mod) {
        final G24TextInput inp = new G24TextInput(value);
        inp.setAlphanumericWithWhitespace();
        inp.setOnEnter(() -> {
            if (inp.getText().isEmpty() || inp.getText().isBlank()) {
                Notifier.error(name + " cannot be empty");
                inp.setText(defaultValue);
            }
        });
        inp.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!inp.getText().isEmpty() && !inp.getText().isBlank()) {
                    mod.modifyString(ItemEditor.get().getNewItem(), inp.getText());
                    ItemSideBar.this.refreshItem();
                }
            }
        });
        return inp;
    }

    private G24NumberInput numericField(String name, int val, int defaultValue, final ModifiesItemNumber mod) {
        final G24NumberInput inp = new G24NumberInput(Integer.toString(val));
        inp.setOnEnter(() -> {
            if (inp.getText().isEmpty() || inp.getText().isBlank()) {
                Notifier.error(name + " cannot be empty");
                inp.setText(Integer.toString(defaultValue));
            }
        });
        inp.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!inp.getText().isEmpty() && !inp.getText().isBlank()) {
                    mod.modifyNumber(ItemEditor.get().getNewItem(), Integer.parseInt(inp.getText().trim()));
                    ItemSideBar.this.refreshItem();
                }
            }
        });
        return inp;
    }

    public ItemSideBar() {
        this.pad(0.0f);
        this.defaults().left().growX();
        G24TextInput nameInp = this.nonEmptyStringField("Name", ItemEditor.get().getNewItem().getItemName(), "None", (i, s) -> {
            i.getType().name = s;
        });
        G24TextInput categoryInp = this.nonEmptyStringField("Category", ItemEditor.get().getNewItem().getType().category, "Custom", (i, s) -> {
            i.getType().category = s;
        });
        G24NumberInput sizeInpWidth = this.numericField("Width", ItemEditor.get().getNewItem().getWidth(), 1, (i, v) -> i.setWidth(v));
        G24NumberInput sizeInpHeight = this.numericField("Height", ItemEditor.get().getNewItem().getHeight(), 1, (i, v) -> i.setHeight(v));
        G24NumberInput renderInp = this.numericField("Render Priority", ItemEditor.get().getNewItem().renderPriority(), 0, (i, v) -> i.setRenderPriority(v));
        final G24TextInput textureInp = this.nonEmptyStringField("Texture", ItemEditor.get().getNewItem().getType().texture, "placeholder", (i, s) -> i.setTexture(AssetManager.instance().getRegion(s)));
        final G24TextButton texturePicker = new G24TextButton("Pick Texture File");
        texturePicker.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (texturePicker.isChecked()) {
                    texturePicker.setChecked(false);
                    TexturePicker.pickTexture(ItemEditor.get().getMapData().getMetadata()).ifPresent(filename -> {
                        if (!MapLoader.reloadTextures(ItemEditor.get().getMapData().getMetadata())) {
                            System.out.println("Failed to reload textures");
                        } else {
                            String sansPng;
                            Item newItem = ItemEditor.get().getNewItem();
                            newItem.getType().texture = sansPng = filename.substring(0, filename.lastIndexOf(".png"));
                            newItem.setTexture(AssetManager.instance().getRegion(sansPng));
                            textureInp.setText(sansPng);
                            ItemEditor.get().markModified();
                        }
                    });
                }
            }
        });
        this.init = i -> {
            nameInp.setText(i.getType().name);
            categoryInp.setText(i.getType().category);
            sizeInpWidth.setText(Integer.toString(i.getType().size.width));
            sizeInpHeight.setText(Integer.toString(i.getType().size.height));
            renderInp.setText(Integer.toString(i.getType().renderPriority));
            textureInp.setText(i.getType().texture);
            this.refreshItem();
            return null;
        };
        this.add(new FieldHeader("Name", null)).row();
        this.add(nameInp).row();
        this.add(new FieldHeader("Category", "Category in the Item Drawer")).row();
        this.add(categoryInp).row();
        this.add(new FieldHeader("Size", null)).row();
        this.add(new SmallLabel("Width: ", "default", 0.65f)).row();
        this.add(sizeInpWidth).row();
        this.add(new SmallLabel("Height: ", "default", 0.65f)).row();
        this.add(sizeInpHeight).row();
        this.add(new FieldHeader("Render Priority", "\"Height\" of this item (e.g. 0 for floors, 5 for player, etc)")).row();
        this.add(renderInp).row();
        this.add(new FieldHeader("Texture", null)).row();
        this.add(textureInp).row();
        this.add(texturePicker).row();
        this.add(new FieldHeader("Properties: ", null)).row();
        this.workspace = new PropertyWorkspace();
        this.add(this.workspace).padTop(10.0f).growY().row();
        this.add(new SaveButton()).row();
        this.add(new QuitButton()).row();
        this.add(new DiscardButton()).row();
    }

    @FunctionalInterface
    private static interface ModifiesItemString {
        public void modifyString(Item var1, String var2);
    }

    @FunctionalInterface
    private static interface ModifiesItemNumber {
        public void modifyNumber(Item var1, int var2);
    }

    private class FieldHeader
    extends SmallLabel {
        FieldHeader(String title, String description) {
            super(title, "underline", 0.65f);
            if (description != null && !description.isEmpty()) {
                new Tooltip.Builder(new SmallLabel(description, "bubble_gray", 0.65f)).target(this, Tooltip.stageHelper(this)).build();
            }
        }
    }

    public class SaveButton
    extends G24TextButton {
        public SaveButton() {
            super(ItemEditor.get().modifyingItem() ? "Save as New Item" : "Save Item");
            this.setProgrammaticChangeEvents(false);
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (SaveButton.this.isChecked()) {
                        SaveButton.this.setChecked(false);
                        ItemEditor.get().saveItem();
                    }
                }
            });
        }
    }

    public class QuitButton
    extends G24TextButton {
        public QuitButton() {
            super("Return to Editor");
            this.setProgrammaticChangeEvents(false);
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (QuitButton.this.isChecked()) {
                        QuitButton.this.setChecked(false);
                        ItemEditor.get().returnToEditor();
                    }
                }
            });
        }
    }

    public class DiscardButton
    extends G24TextButton {
        public DiscardButton() {
            super("Discard Changes");
            this.setProgrammaticChangeEvents(false);
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (DiscardButton.this.isChecked()) {
                        DiscardButton.this.setChecked(false);
                        ItemEditor.get().resetItem();
                    }
                }
            });
        }
    }
}

