/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editor;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import group24.escaperoom.AssetManager;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.widgets.G24Window;

public class Menu
extends G24Window {
    Array<Menu> spawned = new Array();
    AbstractScreen screen;
    @Null
    MenuEntry parent;
    boolean movedIndependent = false;
    Vector2 parentRelativeOffset = new Vector2();

    public AbstractScreen getScreen() {
        return this.screen;
    }

    @Override
    @Null
    public MenuEntry getParent() {
        return this.parent;
    }

    @Override
    protected void positionChanged() {
        this.movedIndependent = true;
        this.spawned.forEach(m -> {
            if (m.movedIndependent) {
                return;
            }
            m.setPosition(this.getX() + m.parentRelativeOffset.x, this.getY() + m.parentRelativeOffset.y);
            m.movedIndependent = false;
        });
    }

    @Override
    public void close() {
        if (this.parent != null) {
            this.parent.childClosed(this);
        }
        this.spawned.forEach(w -> w.close());
        super.close();
    }

    public Menu(@Null MenuEntry parentMenu, String title, AbstractScreen screen) {
        super(title, "menu");
        this.screen = screen;
        this.parent = parentMenu;
        this.padTop(20.0f);
        this.padLeft(5.0f);
        this.defaults().pad(0.0f).align(10).expandX().growX();
        this.add(MenuEntry.divider()).growX().row();
    }

    public void addDivider() {
        this.add(MenuEntry.divider()).minHeight(20.0f).row();
    }

    public static class MenuEntry
    extends Table {
        Drawable hoverBackground;
        boolean selectable = false;
        boolean selected = false;
        Menu parent;
        SelectionHandler onSelect;
        SelectionHandler onDeselect;
        MenuAction onClick;
        @Null
        SpawnsMenu spawnsMenu;
        @Null
        SpawnsMenu spawnsMenuSaved;
        Actor content;

        public AbstractScreen getScreen() {
            return this.parent.getScreen();
        }

        public void childClosed(Menu menu) {
            this.spawnsMenu = this.spawnsMenuSaved;
        }

        private void loadBackground() {
            AssetManager.instance().load("textures/menu_hover.png", Texture.class);
            AssetManager.instance().finishLoadingAsset("textures/menu_hover.png");
            Texture bkg = AssetManager.instance().get("textures/menu_hover.png", Texture.class);
            this.hoverBackground = new TextureRegionDrawable(new TextureRegion(bkg));
        }

        private static Drawable loadDividerBackground() {
            AssetManager.instance().load("textures/menu_divider.png", Texture.class);
            AssetManager.instance().finishLoadingAsset("textures/menu_divider.png");
            Texture bkg = AssetManager.instance().get("textures/menu_divider.png", Texture.class);
            return new TextureRegionDrawable(new TextureRegion(bkg));
        }

        public static MenuEntry divider() {
            MenuEntry entry = new MenuEntry();
            entry.setBackground(MenuEntry.loadDividerBackground());
            return entry;
        }

        public static MenuEntry label(String content) {
            MenuEntry entry = new MenuEntry(null, (Actor)new MenuLabel(content), null, null, null, null, false);
            return entry;
        }

        public void setSelected() {
            this.selected = true;
            this.setBackground(this.hoverBackground);
        }

        private void toggleSelect() {
            if (!this.selectable) {
                return;
            }
            boolean bl = this.selected = !this.selected;
            if (this.selected) {
                this.onSelect.handle();
                this.setBackground(this.hoverBackground);
            }
            if (!this.selected) {
                this.onDeselect.handle();
                this.setBackground((Drawable)null);
            }
        }

        private MenuEntry() {
            this.onSelect = () -> {};
            this.onDeselect = () -> {};
            this.onClick = () -> {};
        }

        public void createNewMenu(Menu m) {
            this.parent.spawned.add(m);
            this.parent.screen.addUI(m);
            Vector2 entryBorder = this.localToStageCoordinates(new Vector2(this.getWidth(), 0.0f));
            m.setPosition(entryBorder.x, entryBorder.y);
            m.movedIndependent = false;
            m.parentRelativeOffset.set(entryBorder.x - this.parent.getX(), entryBorder.y - this.parent.getY());
            m.toFront();
            BackManager.addBack(() -> {
                if (m.getStage() == null) {
                    return false;
                }
                m.close();
                return true;
            });
        }

        protected MenuEntry(Menu parentMenu, Actor entryContent, final SpawnsMenu spawner, SelectionHandler selectHandler, SelectionHandler deselectHandler, MenuAction doesAction, final boolean select) {
            this.onSelect = () -> {};
            this.onDeselect = () -> {};
            this.onClick = () -> {};
            this.left();
            this.padLeft(5.0f);
            this.loadBackground();
            this.add(entryContent).left().expandX().fillX();
            this.content = entryContent;
            this.spawnsMenu = spawner;
            this.selectable = select;
            this.onClick = doesAction;
            this.parent = parentMenu;
            this.onSelect = selectHandler;
            this.onDeselect = deselectHandler;
            if (spawner != null) {
                this.add(new SmallLabel(">", "default", 0.65f)).right().padRight(2.0f);
            }
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    if (button == 1) {
                        return false;
                    }
                    boolean handled = false;
                    if (selectable) {
                        this.toggleSelect();
                        handled = true;
                    }
                    if (spawnsMenu != null) {
                        parent.spawned.forEach(m -> m.close());
                        Menu m2 = spawnsMenu.newMenu(this);
                        this.createNewMenu(m2);
                        spawnsMenuSaved = spawnsMenu;
                        spawnsMenu = null;
                        handled = true;
                    } else if (spawnsMenuSaved != null) {
                        parent.spawned.forEach(m -> m.close());
                        handled = true;
                    }
                    if (onClick != null) {
                        onClick.onClick();
                        handled = true;
                    }
                    if (handled) {
                        event.stop();
                    }
                    return handled;
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, @Null Actor fromActor) {
                    if (select || spawner != null || onClick != null) {
                        this.setBackground(hoverBackground);
                    }
                }

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, @Null Actor toActor) {
                    if (!selected) {
                        this.setBackground((Drawable)null);
                    }
                }
            });
        }
    }

    public static class MenuLabel
    extends SmallLabel {
        public MenuLabel(String label) {
            super(label, "default", 0.65f);
        }
    }

    public static class MenuEntryBuilder {
        final Actor content;
        final Menu parent;
        @Null
        SpawnsMenu menuSpawner;
        SelectionHandler onSelect;
        SelectionHandler onDeselect;
        MenuAction onClick;
        boolean selectable;
        boolean selected;

        public MenuEntryBuilder(Menu parent, Actor content) {
            this.onSelect = () -> {};
            this.onDeselect = () -> {};
            this.onClick = () -> {};
            this.selectable = false;
            this.selected = false;
            this.content = content;
            this.parent = parent;
        }

        public MenuEntryBuilder(Menu parent, String label) {
            this.onSelect = () -> {};
            this.onDeselect = () -> {};
            this.onClick = () -> {};
            this.selectable = false;
            this.selected = false;
            this.content = new MenuLabel(label);
            this.parent = parent;
        }

        public MenuEntryBuilder spawns(SpawnsMenu action) {
            this.menuSpawner = action;
            return this;
        }

        public MenuEntryBuilder onClick(MenuAction action) {
            this.onClick = action;
            return this;
        }

        public MenuEntryBuilder onSelect(SelectionHandler action) {
            this.selectable = true;
            this.onSelect = action;
            return this;
        }

        public MenuEntryBuilder onDeselect(SelectionHandler action) {
            this.selectable = true;
            this.onDeselect = action;
            return this;
        }

        public MenuEntryBuilder selectable(boolean selected) {
            this.selectable = true;
            this.selected = selected;
            return this;
        }

        public MenuEntry build() {
            MenuEntry e = new MenuEntry(this.parent, this.content, this.menuSpawner, this.onSelect, this.onDeselect, this.onClick, this.selectable);
            if (this.selected) {
                e.setSelected();
            }
            return e;
        }
    }

    public class MenuEntryGroup {
        Array<MenuEntry> entries = new Array();
        boolean multiSelect = false;

        public void setMultiSelect(boolean multiSelect) {
            this.multiSelect = multiSelect;
        }

        private void restrictSelection(MenuEntry entry) {
            if (this.multiSelect) {
                return;
            }
            for (MenuEntry e : this.entries) {
                if (e == entry || !e.selected) continue;
                e.toggleSelect();
            }
        }

        public Array<MenuEntry> getSelected() {
            Array<MenuEntry> selected = new Array<MenuEntry>();
            for (MenuEntry e : this.entries) {
                if (!e.selected) continue;
                selected.add(e);
            }
            return selected;
        }

        public void addEntry(MenuEntry entry) {
            if (entry.selectable) {
                SelectionHandler handler = entry.onSelect;
                entry.onSelect = () -> {
                    this.restrictSelection(entry);
                    handler.handle();
                };
                this.entries.add(entry);
            }
        }
    }

    @FunctionalInterface
    public static interface SelectionHandler {
        public void handle();
    }

    @FunctionalInterface
    public static interface MenuAction {
        public void onClick();
    }

    @FunctionalInterface
    public static interface SpawnsMenu {
        public Menu newMenu(MenuEntry var1);
    }
}

