/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editor;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import dev.lyze.flexbox.FlexBox;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.ItemEditor;
import group24.escaperoom.ui.SmallLabel;
import io.github.orioncraftmc.meditate.enums.YogaEdge;
import io.github.orioncraftmc.meditate.enums.YogaFlexDirection;
import io.github.orioncraftmc.meditate.enums.YogaWrap;

public class PropertyBank
extends ScrollPane {
    FlexBox flexBox = new FlexBox();

    public PropertyBank() {
        super(null, AbstractScreen.skin);
        this.flexBox.getRoot().setFlexDirection(YogaFlexDirection.ROW).setWrap(YogaWrap.WRAP).setMargin(YogaEdge.ALL, 20.0f).setMargin(YogaEdge.BOTTOM, 40.0f);
        this.setActor(this.flexBox);
        this.addPropertyPills();
        ItemEditor.get().getDragAndDrop().addTarget(new DragAndDrop.Target(this){

            @Override
            public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                return true;
            }

            @Override
            public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
            }
        });
    }

    @Override
    public void pack() {
        super.pack();
        this.flexBox.pack();
    }

    private void addPropertyPills() {
        for (PropertyType type : PropertyType.values()) {
            if (type == PropertyType.InvalidProperty) continue;
            this.flexBox.add(new PropertyPill(type.getEmptyProperty())).setPadding(YogaEdge.ALL, 10.0f);
        }
    }

    public static class PropertyPill<V extends ItemPropertyValue, P extends ItemProperty<V>>
    extends SmallLabel {
        public PropertyPill(P property) {
            super(((ItemProperty)property).getDescription().name, "bubble", 0.65f);
            this.addListener(CursorManager.hoverHelper(CursorManager.CursorType.Hand));
            ItemEditor.get().getDragAndDrop().addSource(new DragAndDrop.Source(this, (ItemProperty)property){
                final /* synthetic */ ItemProperty val$property;
                {
                    this.val$property = itemProperty;
                    super(arg0);
                }

                @Override
                public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
                    DragAndDrop.Payload pl = new DragAndDrop.Payload();
                    pl.setObject((Object)this.val$property.getType());
                    SmallLabel l = new SmallLabel(this.val$property.getDescription().name, "bubble", 0.65f);
                    l.pack();
                    pl.setDragActor(l);
                    SmallLabel il = new SmallLabel(this.val$property.getDescription().name, "bubble", 0.65f);
                    il.setColor(1.0f, 0.0f, 0.0f, 1.0f);
                    il.pack();
                    pl.setInvalidDragActor(il);
                    SmallLabel vl = new SmallLabel(this.val$property.getDescription().name, "bubble", 0.65f);
                    vl.setColor(0.0f, 1.0f, 0.0f, 1.0f);
                    vl.pack();
                    pl.setValidDragActor(vl);
                    return pl;
                }

                @Override
                public void dragStop(InputEvent event, float x, float y, int pointer, DragAndDrop.Payload payload, DragAndDrop.Target target) {
                    CursorManager.restoreDefault();
                }
            });
        }
    }
}

