/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editor;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.Tooltip;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.widgets.G24NumberInput;
import group24.escaperoom.ui.widgets.G24TextInput;
import java.util.HashMap;

public class PropertyConfiguration
extends Table
implements ConfigurationMenu.HandlesMenuClose {
    public void addToggle(String label, String helpString, boolean initialValue, final OnToggle onToggle) {
        final CheckBox checkBox = new CheckBox(label, AbstractScreen.skin);
        checkBox.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                onToggle.onToggle(checkBox.isChecked());
            }
        });
        checkBox.setChecked(initialValue);
        this.addElement(label, helpString, checkBox, true);
    }

    public void addNumberInput(String label, String helpString, IntInput numberInput) {
        this.addElement(label, helpString, numberInput, false);
    }

    public void addNumberInput(String label, String helpString, FloatInput numberInput) {
        this.addElement(label, helpString, numberInput, false);
    }

    public <T> void addSelect(String label, String helpString, Select<T> select) {
        this.addElement(label, helpString, select, true);
    }

    public void addElement(String label, String helpString, Actor a, boolean separateByLine) {
        SmallLabel labelEl = new SmallLabel(label + ":", "default", 0.65f);
        if (helpString != null && !helpString.isEmpty()) {
            new Tooltip.Builder(helpString).target(labelEl, Tooltip.stageHelper(labelEl)).build();
        }
        this.add(labelEl).left();
        if (separateByLine) {
            this.row();
        }
        this.add(a).left().row();
    }

    public void addLine() {
        this.add(new SmallLabel("", "default", 0.65f)).row();
    }

    @Override
    public void handle() {
    }

    public static interface OnToggle {
        public void onToggle(boolean var1);
    }

    public static class FloatInput
    extends G24TextInput {
        public FloatInput(float initialValue, final OnFloatChange onChange) {
            super(Float.toString(initialValue));
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    String newValueStr = this.getText();
                    if (newValueStr.isBlank() || newValueStr.isEmpty()) {
                        return;
                    }
                    onChange.onChange(Float.parseFloat(newValueStr));
                }
            });
            this.setFilter(c -> {
                String newText = this.getText() + c;
                try {
                    Float.parseFloat(newText);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return true;
            });
        }

        public static interface OnFloatChange {
            public void onChange(float var1);
        }
    }

    public static class IntInput
    extends G24NumberInput {
        public IntInput(int initialValue, final OnIntChange onChange) {
            super(Integer.toString(initialValue));
            this.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    String newValueStr = this.getText();
                    if (newValueStr.isBlank() || newValueStr.isEmpty()) {
                        return;
                    }
                    onChange.onChange(Integer.parseInt(newValueStr));
                }
            });
        }

        public static interface OnIntChange {
            public void onChange(int var1);
        }
    }

    public static class Select<T>
    extends VerticalGroup {
        public Select(final OnSelect onSelect, final OnDeselect onDeselect, T[] options, Stringify toDisplay, int maxSelected, T ... initialSelections) {
            this.columnLeft();
            ButtonGroup<CheckBox> checkBtnGroup = new ButtonGroup<CheckBox>();
            checkBtnGroup.setMaxCheckCount(maxSelected);
            checkBtnGroup.setMinCheckCount(1);
            HashMap<T, CheckBox> buttonMap = new HashMap<T, CheckBox>();
            for (final T val : options) {
                final CheckBox check = new CheckBox(toDisplay.stringify(val), AbstractScreen.skin);
                buttonMap.put(val, check);
                checkBtnGroup.add(check);
                check.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if (check.isChecked()) {
                            onSelect.onChange(val);
                        } else {
                            onDeselect.onChange(val);
                        }
                    }
                });
                this.addActor(check);
            }
            for (final T val : initialSelections) {
                CheckBox box = (CheckBox)buttonMap.get(val);
                if (box == null) continue;
                box.setChecked(true);
            }
        }

        public static interface Stringify {
            public String stringify(Object var1);
        }

        public static interface OnSelect {
            public void onChange(Object var1);
        }

        public static interface OnDeselect {
            public void onChange(Object var1);
        }
    }
}

