/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editor;

import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.screens.ItemEditor;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editor.ConfigurationMenu;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.editor.PropertyConfiguration;

public class PropertyConfigurationMenu
extends Menu {
    public PropertyConfigurationMenu(ItemProperty<? extends ItemPropertyValue> property) {
        super(null, property.getDescription().name, ItemEditor.screen);
        this.add(new SpecialLittleTinyBabyLabel(property.getDescription().shortDesc)).row();
        this.add(Menu.MenuEntry.divider()).row();
        property.getCustomItemConfigurationMenu().ifPresent(config -> this.add(new Menu.MenuEntryBuilder((Menu)this, "Configure").spawns(parent -> {
            ItemEditor.get().markModified();
            return new ConfigurationMenu<PropertyConfiguration>(parent, (PropertyConfiguration)config, property.getDescription().name + " Configuration", this.screen);
        }).build()).row());
        this.add(new Menu.MenuEntryBuilder((Menu)this, "Help").spawns(parent -> new ConfigurationMenu<SpecialLittleTinyBabyLabel>(parent, new SpecialLittleTinyBabyLabel(property.getDescription().longDesc), property.getDescription().name + " Details", this.screen)).build()).row();
        if (!property.getDescription().mutallyExclusiveWith.isEmpty()) {
            this.add(new Menu.MenuEntryBuilder((Menu)this, "Conflicting Properties ").spawns(parent -> {
                ConfigurationMenu.VGroup conflicts = new ConfigurationMenu.VGroup();
                property.getDescription().mutallyExclusiveWith.forEach(p -> {
                    if (p != property.getType()) {
                        conflicts.addActor(new SmallLabel(p.getEmptyProperty().getDescription().name, "bubble", 0.65f));
                    }
                });
                return new ConfigurationMenu<ConfigurationMenu.VGroup>(parent, conflicts, property.getDescription().name + " Conflicts", this.screen);
            }).build()).row();
        }
        this.pack();
    }

    private class SpecialLittleTinyBabyLabel
    extends SmallLabel
    implements ConfigurationMenu.HandlesMenuClose {
        SpecialLittleTinyBabyLabel(String content) {
            super(content, "default", 0.65f);
            this.setWrap(true);
            this.setWidth(150.0f);
        }

        @Override
        public void handle() {
        }
    }
}

