/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editor;

import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.BooleanProperty;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.editor.Menu;
import java.util.HashMap;

public class PropertyMenu
extends Menu {
    public PropertyMenu(Menu.MenuEntry parent, Item item, LevelEditorScreen editor) {
        super(parent, "Properties", editor);
        for (ItemProperty<? extends ItemPropertyValue> property : item.getProperties()) {
            switch (property.getInputType()) {
                case Toggleable: {
                    this.addToggle((BooleanProperty)property);
                    break;
                }
                case PopOut: {
                    this.addPopOut(property);
                    break;
                }
                case Select: {
                    this.addSelect(property, true);
                    break;
                }
                case SelectOne: {
                    this.addSelect(property, false);
                    break;
                }
            }
        }
        this.pack();
    }

    private <V extends ItemPropertyValue, P extends ItemProperty<V>> void addSelect(P property, boolean multiselect) {
        Menu.MenuEntryGroup group = new Menu.MenuEntryGroup();
        HashMap<Menu.MenuEntry, ItemPropertyValue> values = new HashMap<Menu.MenuEntry, ItemPropertyValue>();
        V selectedValue = property.getCurrentValue();
        Menu popOutMenu = new Menu(null, property.getDisplayName(), this.screen);
        for (ItemPropertyValue value : property.getPotentialValues()) {
            Menu.MenuEntry entry2 = value.getDisplay(popOutMenu);
            values.put(entry2, value);
            entry2.selectable = true;
            if (value.equals(selectedValue)) {
                entry2.setSelected();
            }
            Menu.SelectionHandler handler = entry2.onSelect;
            entry2.onSelect = () -> {
                if (multiselect) {
                    Array valuesToSet = new Array(property.getValueClass());
                    group.getSelected().forEach(me -> valuesToSet.add((ItemPropertyValue)values.get(me)));
                    property.set(valuesToSet);
                } else {
                    property.set(value);
                }
                handler.handle();
            };
            group.addEntry(entry2);
        }
        Menu.MenuEntry e = new Menu.MenuEntryBuilder((Menu)this, property.getDisplayName()).spawns(entry -> {
            popOutMenu.parent = entry;
            group.entries.forEach(ent -> popOutMenu.add(ent).row());
            return popOutMenu;
        }).build();
        this.add(new PropertyMenuEntry(e, property)).row();
    }

    private <V extends ItemPropertyValue, P extends ItemProperty<V>> void addPopOut(P property) {
        this.add(new PropertyMenuEntry(new Menu.MenuEntryBuilder((Menu)this, property.getDisplayName()).spawns(m -> property.getPopOut(m)).build(), property)).row();
    }

    private <P extends BooleanProperty> void addToggle(P property) {
        CheckBox checkBox = new CheckBox(property.getDisplayName(), AbstractScreen.skin);
        Menu.MenuEntry entry = new Menu.MenuEntryBuilder((Menu)this, checkBox).onSelect(() -> property.set(new BooleanProperty.BooleanValue(true))).onDeselect(() -> property.set(new BooleanProperty.BooleanValue(false))).build();
        if (property.getCurrentValue().isTrue()) {
            entry.setSelected();
        }
        this.add(Menu.MenuEntry.divider()).row();
        this.add(new PropertyMenuEntry(entry, property)).row();
        this.add(Menu.MenuEntry.divider()).row();
    }

    public static class PropertyMenuEntry
    extends Menu.MenuEntry {
        ItemProperty<? extends ItemPropertyValue> property;

        protected PropertyMenuEntry(Menu.MenuEntry base, ItemProperty<? extends ItemPropertyValue> property) {
            super(base.parent, base.content, base.spawnsMenu, base.onSelect, base.onDeselect, base.onClick, base.selectable);
            this.property = property;
        }

        public ItemProperty<? extends ItemPropertyValue> getProperty() {
            return this.property;
        }
    }
}

