/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editor;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import com.badlogic.gdx.utils.Null;
import dev.lyze.flexbox.FlexBox;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.ItemEditor;
import group24.escaperoom.ui.SmallLabel;
import io.github.orioncraftmc.meditate.YogaNode;
import io.github.orioncraftmc.meditate.enums.YogaEdge;
import io.github.orioncraftmc.meditate.enums.YogaFlexDirection;
import io.github.orioncraftmc.meditate.enums.YogaWrap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class PropertyWorkspace
extends ScrollPane {
    private HashMap<PropertyType, YogaNode> nodes = new HashMap();
    private HashSet<PropertyPill<?, ?>> pills = new HashSet();
    private FlexBox flexBox = new FlexBox();

    private void addPill(ItemProperty<?> property) {
        PropertyPill pill = new PropertyPill(this, property);
        YogaNode node = this.flexBox.add(pill).setPadding(YogaEdge.ALL, 10.0f);
        this.nodes.put(property.getType(), node);
        this.pills.add(pill);
        this.flexBox.pack();
        ItemEditor.get().repack();
    }

    public Set<PropertyPill<?, ?>> getPills() {
        return this.pills;
    }

    public void populateFor(Item item) {
        for (PropertyType propertyType : this.nodes.keySet()) {
            this.flexBox.remove(this.nodes.get((Object)propertyType));
        }
        this.flexBox.clear();
        this.flexBox.pack();
        this.nodes.clear();
        ItemEditor.get().repack();
        for (ItemProperty itemProperty : item.getProperties()) {
            this.addPill(itemProperty);
        }
    }

    public PropertyWorkspace() {
        super(null, AbstractScreen.skin);
        this.setActor(this.flexBox);
        this.flexBox.getRoot().setFlexDirection(YogaFlexDirection.ROW).setWrap(YogaWrap.WRAP);
        ItemEditor.get().getDragAndDrop().addTarget(new DragAndDrop.Target(this){

            @Override
            public boolean drag(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                PropertyType type = (PropertyType)((Object)payload.getObject());
                return !ItemEditor.get().getNewItem().hasProperty(type) && !ItemEditor.get().getNewItem().getProperties().stream().anyMatch(prop -> prop.getDescription().mutallyExclusiveWith.contains((Object)type));
            }

            @Override
            public void drop(DragAndDrop.Source source, DragAndDrop.Payload payload, float x, float y, int pointer) {
                PropertyType type = (PropertyType)((Object)payload.getObject());
                ItemProperty<? extends ItemPropertyValue> prop = type.getEmptyProperty();
                ItemEditor.get().getNewItem().addProperty(prop);
                prop.apply(ItemEditor.get().getNewItem());
                PropertyWorkspace.this.addPill(prop);
                ItemEditor.get().markModified();
            }
        });
    }

    public static class PropertyPill<V extends ItemPropertyValue, P extends ItemProperty<V>>
    extends SmallLabel {
        P property;
        final /* synthetic */ PropertyWorkspace this$0;

        public P getProperty() {
            return this.property;
        }

        public PropertyPill(P property) {
            this.this$0 = this$0;
            super(((ItemProperty)property).getDescription().name, "bubble", 0.65f);
            this.addListener(CursorManager.hoverHelper(CursorManager.CursorType.Hand));
            this.property = property;
            ItemEditor.get().getDragAndDrop().addSource(new DragAndDrop.Source(this, (ItemProperty)property){
                final /* synthetic */ ItemProperty val$property;
                {
                    this.val$property = itemProperty;
                    super(arg0);
                }

                @Override
                public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
                    DragAndDrop.Payload pl = new DragAndDrop.Payload();
                    pl.setObject((Object)this.val$property.getType());
                    SmallLabel l = new SmallLabel(this.val$property.getDescription().name, "bubble", 0.65f);
                    l.pack();
                    pl.setDragActor(l);
                    SmallLabel il = new SmallLabel(this.val$property.getDescription().name, "bubble", 0.65f);
                    il.setColor(1.0f, 0.0f, 0.0f, 1.0f);
                    il.pack();
                    pl.setInvalidDragActor(il);
                    SmallLabel vl = new SmallLabel(this.val$property.getDescription().name, "bubble", 0.65f);
                    vl.setColor(0.0f, 1.0f, 0.0f, 1.0f);
                    vl.pack();
                    pl.setValidDragActor(vl);
                    PropertyPill.this.setVisible(true);
                    return pl;
                }

                @Override
                public void dragStop(InputEvent event, float x, float y, int pointer, @Null DragAndDrop.Payload payload, @Null DragAndDrop.Target target) {
                    if (target != null) {
                        ItemEditor.get().getDragAndDrop().removeSource(this);
                        ItemEditor.get().getNewItem().removeProperty(this.val$property.getType());
                        PropertyPill.this.remove();
                        PropertyPill.this.this$0.flexBox.remove((YogaNode)PropertyPill.this.this$0.nodes.get((Object)this.val$property.getType()));
                        PropertyPill.this.this$0.nodes.remove((Object)this.val$property.getType());
                        ItemEditor.get().markModified();
                    } else {
                        PropertyPill.this.setVisible(true);
                    }
                }
            });
        }
    }
}

