/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editor;

import group24.escaperoom.data.MapMetadata;
import group24.escaperoom.utils.FilePicker;
import group24.escaperoom.utils.FileUtils;
import java.io.File;
import java.util.Optional;
import javax.swing.filechooser.FileNameExtensionFilter;

public class TexturePicker {
    public static Optional<String> pickTexture(MapMetadata metadata) {
        FileNameExtensionFilter filter = new FileNameExtensionFilter("PNGs", "png");
        File home = new File(System.getProperty("user.home"));
        Optional<File> picked = FilePicker.pick("Select Texture", home, filter);
        if (picked.isEmpty()) {
            return Optional.empty();
        }
        if (!TexturePicker.makeTextureDirectory(metadata)) {
            return Optional.empty();
        }
        FileUtils.copy(picked.get().toPath(), new File(metadata.textureDirectory.get(), picked.get().getName()).toPath());
        return Optional.of(picked.get().toPath().getFileName().toString());
    }

    private static boolean makeTextureDirectory(MapMetadata metadata) {
        String texturePath = metadata.textureDirectory.orElse(metadata.locations.mapContentPath + "/textures");
        File textureDir = new File(texturePath);
        if (!textureDir.exists() && !FileUtils.tryCreateFolder(textureDir)) {
            return false;
        }
        metadata.textureDirectory = Optional.of(texturePath);
        return true;
    }
}

