/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editorTools.EditorTool;
import java.util.Optional;

public abstract class Brush
extends EditorTool {
    private InputListener listener = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            return Brush.this.handleTouchDown(x, y);
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            Brush.this.handleTouchUp();
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            Brush.this.handleDrag(x, y);
        }
    };

    public Brush(LevelEditorScreen editor) {
        super(editor);
    }

    @Override
    public void select() {
        CursorManager.setCursor(CursorManager.CursorType.Brush);
        this.editor.addListener(this.listener);
    }

    @Override
    public void cancel() {
        CursorManager.restoreDefault();
        this.editor.removeListener(this.listener);
    }

    public abstract Optional<Item> draw(int var1, int var2);

    public abstract boolean handleTouchDown(float var1, float var2);

    public abstract void handleTouchUp();

    public abstract void handleDrag(float var1, float var2);

    public abstract Item getItem();

    public abstract boolean isDrawing();

    @Override
    public ToolManager.ToolType getType() {
        return ToolManager.ToolType.Brush;
    }
}

