/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.ActionHistory;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editorTools.EditorTool;
import group24.escaperoom.ui.editorTools.SelectionTool;
import java.util.Optional;

public class DeletionTool
extends EditorTool {
    Types.IntVector2 touchDown = new Types.IntVector2(-1, -1);
    boolean deleting;
    private InputListener deleteListener = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            return DeletionTool.this.handleTouchDown(x, y);
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            DeletionTool.this.handleDrag(x, y);
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            DeletionTool.this.deleting = false;
        }
    };

    public DeletionTool(LevelEditorScreen editor) {
        super(editor);
    }

    public boolean isDeleting() {
        return this.deleting;
    }

    public void handleDrag(float x, float y) {
        if (this.touchDown.equals((int)x, (int)y)) {
            return;
        }
        this.touchDown.set(x, y);
        this.deleteAt(x, y);
    }

    @Override
    public void select() {
        CursorManager.setCursor(CursorManager.CursorType.Delete);
        this.editor.addListener(this.deleteListener);
    }

    @Override
    public void cancel() {
        CursorManager.restoreDefault();
        this.editor.removeListener(this.deleteListener);
    }

    private boolean deleteAt(float x, float y) {
        Optional<SelectionTool.Selection> selection = this.editor.getSelectionTool().getSelection();
        if (selection.isPresent() && selection.get().getArea().contains(new Vector2(x, y))) {
            this.editor.getSelectionTool().deleteSelected();
            return true;
        }
        Optional<Item> oTarget = this.editor.priorityItemAt((int)x, (int)y);
        if (oTarget.isPresent()) {
            oTarget.get().remove();
            this.editor.recordEditorAction(new Deletion(this.editor, oTarget.get()));
            this.deleting = true;
            return true;
        }
        return false;
    }

    private boolean handleTouchDown(float x, float y) {
        this.touchDown.set(x, y);
        this.deleteAt(x, y);
        return true;
    }

    @Override
    public String getButtonStyle() {
        return "deleteButton";
    }

    @Override
    public ToolManager.ToolType getType() {
        return ToolManager.ToolType.Deletion;
    }

    @Override
    public String getName() {
        return "Delete";
    }

    public static class Deletion
    implements ActionHistory.EditorAction {
        Array<Item> objs;
        LevelEditorScreen editor;

        public Deletion(LevelEditorScreen editor, Item ... objs) {
            this.objs = Array.with(objs);
            this.editor = editor;
        }

        @Override
        public void doAction() {
            this.objs.forEach(o -> o.remove());
        }

        @Override
        public void undoAction() {
            this.objs.forEach(o -> this.editor.placeItem((Item)o));
        }
    }
}

