/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.control.Input;
import group24.escaperoom.control.InputOverride;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.DragManager;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editorTools.EditorTool;
import group24.escaperoom.ui.editorTools.ItemBrush;
import group24.escaperoom.ui.editorTools.TiledBrush;
import group24.escaperoom.utils.Notifier;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class EyeDropTool
extends EditorTool {
    private State state = State.Idle;
    private Item template = null;
    private Item preview = null;
    private ItemBrush brush;
    private static final HashSet<Input> overridenInputs = new HashSet<Input>(Set.of(Input.ROTCW, Input.ROTCCW, Input.MIRROR_V, Input.MIRROR_H));
    InputOverride inputOverride = new InputOverride(){

        @Override
        public boolean handleInput(Input input, ControlsManager.InputType type) {
            if (type != ControlsManager.InputType.PRESSED) {
                return false;
            }
            if (EyeDropTool.this.state != State.Previewing) {
                return false;
            }
            switch (input) {
                case ROTCW: {
                    EyeDropTool.this.preview.rotateBy(90);
                    return true;
                }
                case ROTCCW: {
                    EyeDropTool.this.preview.rotateBy(-90);
                    return true;
                }
                case MIRROR_H: {
                    EyeDropTool.this.preview.mirrorHorizontal();
                    return true;
                }
                case MIRROR_V: {
                    EyeDropTool.this.preview.mirrorVertical();
                    return true;
                }
            }
            return false;
        }

        @Override
        public Set<Input> getOverriddenInputs() {
            return overridenInputs;
        }
    };
    private final InputListener listener = new InputListener(){

        @Override
        public boolean mouseMoved(InputEvent event, float x, float y) {
            if (EyeDropTool.this.state != State.Previewing || EyeDropTool.this.preview == null) {
                return false;
            }
            Types.IntVector2 pos = new Types.IntVector2(x, y);
            if (EyeDropTool.this.editor.canPlace(EyeDropTool.this.preview, pos)) {
                CursorManager.setCursor(CursorManager.CursorType.CopyPaste);
                EyeDropTool.this.preview.moveTo(pos.x, pos.y);
                EyeDropTool.this.preview.setColor(1.0f, 1.0f, 1.0f, 0.5f);
            } else {
                CursorManager.setCursor(CursorManager.CursorType.InvalidCopyPaste);
                EyeDropTool.this.preview.setColor(1.0f, 0.5f, 0.5f, 0.5f);
            }
            return false;
        }

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            switch (EyeDropTool.this.state) {
                case Idle: {
                    if (button != 0) {
                        return false;
                    }
                    Optional<Item> target = EyeDropTool.this.editor.priorityItemAt((int)x, (int)y);
                    if (target.isEmpty()) {
                        return false;
                    }
                    EyeDropTool.this.copyItem(target.get());
                    return true;
                }
                case Previewing: {
                    if (button == 0) {
                        return EyeDropTool.this.attemptPlacement(x, y);
                    }
                    if (button == 1) {
                        Optional<Item> t = EyeDropTool.this.editor.priorityItemAt((int)x, (int)y);
                        if (t.isPresent()) {
                            EyeDropTool.this.copyItem(t.get());
                        }
                        return true;
                    }
                    return false;
                }
                case Placing: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            if (EyeDropTool.this.state != State.Placing) {
                return;
            }
            EyeDropTool.this.brush.handleDrag(x, y);
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            if (EyeDropTool.this.state == State.Placing) {
                EyeDropTool.this.brush.handleTouchUp();
                EyeDropTool.this.state = State.Previewing;
            }
        }
    };

    public EyeDropTool(LevelEditorScreen editor) {
        super(editor);
    }

    public void copyItem(Item source) {
        this.destroyPreview();
        this.template = source.copy();
        this.createPreviewAt(source.getPosition());
        Notifier.info("Copied " + this.template.getItemName());
        this.state = State.Previewing;
        CursorManager.setCursor(CursorManager.CursorType.CopyPaste);
        BackManager.addBack(() -> {
            this.cancel();
            return false;
        });
    }

    public void pasteAt(Vector2 at) {
        if (this.state == State.Idle) {
            return;
        }
        this.attemptPlacement(at.x, at.y);
        this.state = State.Previewing;
    }

    private void createPreviewAt(Types.IntVector2 pos) {
        this.preview = this.template.clone(false);
        this.preview.setAlpha(0.5f);
        this.preview.setPosition(pos);
        this.editor.placeItem(this.preview);
        this.brush = this.preview.hasProperty(PropertyType.TiledBrushable) ? new TiledBrush(this.editor, this.preview) : new ItemBrush(this.editor, this.preview);
        this.brush.setItem(this.preview);
    }

    private void destroyPreview() {
        if (this.preview != null) {
            this.preview.remove();
        }
        this.preview = null;
        this.template = null;
        this.state = State.Idle;
    }

    private boolean attemptPlacement(float x, float y) {
        if (this.preview == null) {
            return false;
        }
        Types.IntVector2 pos = new Types.IntVector2(x, y);
        if (!this.editor.canPlace(this.preview, pos)) {
            Notifier.warn("Invalid placement for " + this.template.getItemName());
            return false;
        }
        Item placed = this.preview.clone(false);
        placed.setPosition(pos);
        this.editor.placeItem(placed);
        this.editor.recordEditorAction(new DragManager.PlacementAction(placed, this.editor));
        this.brush.handleTouchDown(x, y);
        this.state = State.Placing;
        return true;
    }

    @Override
    public void select() {
        CursorManager.setCursor(CursorManager.CursorType.EyeDrop);
        this.editor.addListener(this.listener);
        ControlsManager.pushOverride(this.inputOverride);
    }

    @Override
    public void cancel() {
        CursorManager.restoreDefault();
        this.editor.removeListener(this.listener);
        this.destroyPreview();
        ControlsManager.popOverride(this.inputOverride);
    }

    @Override
    public ToolManager.ToolType getType() {
        return ToolManager.ToolType.EyeDrop;
    }

    @Override
    public String getName() {
        return "Eye Dropper";
    }

    @Override
    public String getButtonStyle() {
        return "eyedropper";
    }

    private static enum State {
        Idle,
        Previewing,
        Placing;

    }
}

