/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.TiledBrushable;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.ActionHistory;
import group24.escaperoom.screens.editor.DragManager;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editorTools.Brush;
import group24.escaperoom.ui.editorTools.EditorTool;
import java.util.Optional;

public class FillTool
extends EditorTool {
    private Brush brush;
    boolean[][] visited = new boolean[27][48];
    private InputListener listener = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            return FillTool.this.startFlood((int)x, (int)y);
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            FillTool.this.resetVisted();
        }
    };

    public FillTool(LevelEditorScreen stage) {
        super(stage);
        this.resetVisted();
    }

    public Brush getBrush() {
        return this.brush;
    }

    public void setBrush(Brush b) {
        this.brush = b;
    }

    private void resetVisted() {
        for (int y = 0; y < 27; ++y) {
            for (int x = 0; x < 48; ++x) {
                this.visited[y][x] = false;
            }
        }
    }

    private boolean validLocation(int x, int y) {
        return x >= 0 && x < 48 && y >= 0 && y < 27 && !this.visited[y][x];
    }

    private boolean flood(int x, int y, FloodAction action) {
        if (!this.validLocation(x, y)) {
            return false;
        }
        this.visited[y][x] = true;
        if (!action.visit(x, y)) {
            return false;
        }
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                if (Math.abs(dy) == Math.abs(dx)) continue;
                this.flood(x + dx, y + dy, action);
            }
        }
        return true;
    }

    private boolean startFlood(int x, int y) {
        if (!this.validLocation(x, y)) {
            return false;
        }
        FloodAction action = this.editor.getItemsAt(x, y).map(items -> {
            for (Item item : items) {
                if (item.renderPriority() != this.brush.getItem().renderPriority()) continue;
                return new Replace(item);
            }
            return new Fill();
        }).orElse(new Fill());
        if (this.flood(x, y, action)) {
            action.recordEditorAction();
            return true;
        }
        return false;
    }

    @Override
    public void select() {
        this.resetVisted();
        CursorManager.setCursor(CursorManager.CursorType.Fill);
        this.editor.addListener(this.listener);
    }

    @Override
    public void cancel() {
        CursorManager.restoreDefault();
        this.editor.removeListener(this.listener);
    }

    @Override
    public String getName() {
        return "Fill Tool";
    }

    @Override
    public ToolManager.ToolType getType() {
        return ToolManager.ToolType.Fill;
    }

    @Override
    public String getButtonStyle() {
        return "fill";
    }

    private static interface FloodAction {
        public boolean visit(int var1, int var2);

        public void recordEditorAction();
    }

    private class Fill
    implements FloodAction {
        Array<DragManager.PlacementAction> placements = new Array();

        private Fill() {
        }

        @Override
        public boolean visit(int x, int y) {
            Optional<Item[]> oItems = FillTool.this.editor.getItemsAt(x, y);
            if (oItems.isPresent()) {
                for (Item i2 : oItems.get()) {
                    if (!i2.hasProperty(PropertyType.Barrier) && FillTool.this.brush.getItem().renderPriority() != i2.renderPriority()) continue;
                    return false;
                }
            }
            FillTool.this.brush.draw(x, y).ifPresent(i -> this.placements.add(new DragManager.PlacementAction((Item)i, FillTool.this.editor)));
            return true;
        }

        @Override
        public void recordEditorAction() {
            FillTool.this.editor.recordEditorAction(new FloodFillAction(this.placements));
        }
    }

    private class Replace
    implements FloodAction {
        Item target;
        Array<ReplacementAction> replacements = new Array();

        public Replace(Item target) {
            this.target = target;
        }

        @Override
        public boolean visit(int x, int y) {
            Item toReplace = FillTool.this.editor.getItemsAt(x, y).flatMap(items -> {
                for (Item item : items) {
                    if (!item.getItemName().equals(this.target.getItemName())) continue;
                    return Optional.of(item);
                }
                return Optional.empty();
            }).orElse(null);
            if (toReplace == null) {
                return false;
            }
            toReplace.remove();
            FillTool.this.brush.draw(x, y).ifPresent(i -> this.replacements.add(new ReplacementAction(toReplace, (Item)i)));
            return true;
        }

        @Override
        public void recordEditorAction() {
            FillTool.this.editor.recordEditorAction(new FloodReplaceAction(this.replacements));
        }
    }

    private class FloodReplaceAction
    implements ActionHistory.EditorAction {
        private Array<ReplacementAction> replacements;

        private FloodReplaceAction(Array<ReplacementAction> replacements) {
            this.replacements = replacements;
        }

        @Override
        public void doAction() {
            this.replacements.forEach(pa -> pa.doAction());
        }

        @Override
        public void undoAction() {
            this.replacements.forEach(pa -> pa.undoAction());
        }
    }

    private class ReplacementAction
    implements ActionHistory.EditorAction {
        private Item removed;
        private Item added;

        private ReplacementAction(Item removed, Item added) {
            this.removed = removed;
            this.added = added;
        }

        @Override
        public void doAction() {
            this.removed.remove();
            FillTool.this.editor.placeItem(this.added);
            this.added.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tbp -> tbp.refreshAdjacency(FillTool.this.editor));
        }

        @Override
        public void undoAction() {
            this.added.remove();
            FillTool.this.editor.placeItem(this.removed);
            this.removed.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tbp -> tbp.refreshAdjacency(FillTool.this.editor));
        }
    }

    private class FloodFillAction
    implements ActionHistory.EditorAction {
        private Array<DragManager.PlacementAction> placements;

        private FloodFillAction(Array<DragManager.PlacementAction> placements) {
            this.placements = placements;
        }

        @Override
        public void doAction() {
            this.placements.forEach(pa -> pa.doAction());
        }

        @Override
        public void undoAction() {
            this.placements.forEach(pa -> pa.undoAction());
        }
    }
}

