/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.Connectable;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.screens.editor.DragManager;
import group24.escaperoom.ui.editorTools.Brush;
import group24.escaperoom.ui.editorTools.DeletionTool;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;

public class ItemBrush
extends Brush {
    Item item;
    Array<Types.IntVector2> path = new Array();
    HashSet<Integer> addedIDs = new HashSet();

    public ItemBrush(LevelEditorScreen stage, Item item) {
        super(stage);
        this.item = item;
    }

    @Override
    public void handleTouchUp() {
        this.path.clear();
    }

    public void setItem(Item item) {
        this.item = item;
    }

    @Override
    public void handleDrag(float x, float y) {
        Types.IntVector2 newPos = new Types.IntVector2(x, y);
        if (newPos.equals(this.path.get(this.path.size - 1))) {
            return;
        }
        if (this.path.size >= 2 && newPos.equals(this.path.get(this.path.size - 2))) {
            this.placedItemAt(this.path.get(this.path.size - 1)).ifPresent(i -> {
                i.remove(false);
                this.editor.recordEditorAction(new DeletionTool.Deletion(this.editor, (Item)i));
            });
            this.path.pop();
            return;
        }
        Optional<Item> matchingItem = ItemBrush.matchingItemAt(newPos, this.path.get(this.path.size - 1), this.editor, this.item);
        if (matchingItem.isPresent()) {
            this.addedIDs.add(matchingItem.get().getID());
            this.path.add(newPos);
            return;
        }
        Item newItem = this.item.clone();
        if (this.editor.canPlace(newItem, newPos)) {
            this.placeAt(newItem, newPos);
        }
    }

    @Override
    public boolean handleTouchDown(float x, float y) {
        Types.IntVector2 newPos = new Types.IntVector2(x, y);
        Optional<Item> matchingItem = ItemBrush.matchingItemAt(newPos, newPos, this.editor, this.item);
        if (matchingItem.isPresent()) {
            this.path.add(newPos);
            return true;
        }
        Item newItem = this.item.clone();
        if (this.editor.canPlace(newItem, newPos)) {
            this.placeAt(newItem, newPos);
            return true;
        }
        return false;
    }

    protected static Optional<Item> matchingItemAt(Types.IntVector2 checkPos, Types.IntVector2 matchToPos, MapScreen editor, Item itemToMatch) {
        Optional<Connectable.ConnectableItem> maybeConnectable = Connectable.Utils.isConnectable(itemToMatch);
        if (maybeConnectable.isPresent()) {
            return editor.getItemsAt(checkPos.x, checkPos.y).flatMap(canidates -> {
                Connectable itemToMatchConnectable = ((Connectable.ConnectableItem)maybeConnectable.get()).connectable;
                for (int i = 0; i < ((Item[])canidates).length; ++i) {
                    Item canidate = canidates[i];
                    Optional<Connectable.ConnectableItem> maybeConnectableCanidate = Connectable.Utils.isConnectable(canidate).filter(ci -> ci.connectable.getConnectorType() == itemToMatchConnectable.getConnectorType());
                    if (!maybeConnectableCanidate.isPresent()) continue;
                    if (matchToPos.equals(checkPos)) {
                        return Optional.of(canidate);
                    }
                    Connectable.ConnectableItem connectableItem = maybeConnectableCanidate.get();
                    Types.IntVector2 offset = matchToPos.cpy().sub(checkPos);
                    if (!Arrays.stream(connectableItem.connectable.connectionDirections()).anyMatch(v -> v.equals(offset))) continue;
                    return Optional.of(canidate);
                }
                return Optional.empty();
            });
        }
        return editor.getItemsAt(checkPos.x, checkPos.y).flatMap(items -> {
            for (int i = 0; i < ((Item[])items).length; ++i) {
                if (!items[i].getItemName().equals(itemToMatch.getItemName())) continue;
                return Optional.of(items[i]);
            }
            return Optional.empty();
        });
    }

    protected Optional<Item> placedItemAt(Types.IntVector2 pos) {
        return this.editor.getItemsAt(pos.x, pos.y).flatMap(items -> {
            for (int i = 0; i < ((Item[])items).length; ++i) {
                if (!this.addedIDs.contains(items[i].getID())) continue;
                return Optional.of(items[i]);
            }
            return Optional.empty();
        });
    }

    protected void placeAt(Item newItem, Types.IntVector2 newPosition) {
        newItem.setPosition(newPosition);
        this.addedIDs.add(newItem.getID());
        this.path.add(newPosition);
        this.editor.placeItem(newItem);
        this.editor.recordEditorAction(new DragManager.PlacementAction(newItem, this.editor));
    }

    @Override
    public String getName() {
        return this.item.getItemName() + " Brush";
    }

    @Override
    public Optional<Item> draw(int x, int y) {
        Types.IntVector2 newPos = new Types.IntVector2(x, y);
        Item newItem = this.item.clone();
        if (this.editor.canPlace(newItem, newPos)) {
            newItem.setPosition(newPos);
            this.editor.placeItem(newItem);
            return Optional.of(newItem);
        }
        return Optional.empty();
    }

    @Override
    public boolean isDrawing() {
        return this.path.size > 0;
    }

    @Override
    public Item getItem() {
        return this.item;
    }
}

