/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.scenes.scene2d.utils.DragAndDrop;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Scaling;
import group24.escaperoom.AssetManager;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.ui.ItemSlot;
import group24.escaperoom.ui.SmallLabel;
import group24.escaperoom.ui.editorTools.Brush;
import group24.escaperoom.ui.editorTools.ItemBrush;
import group24.escaperoom.ui.editorTools.TiledBrush;
import java.util.Optional;
import java.util.function.Predicate;

public class ItemDrawer
extends Tree<ItemCategory, Item> {
    LevelEditorScreen editor;
    Array<Item> prototypes = new Array();

    public Array<Item> getItemPrototypes() {
        return this.prototypes;
    }

    private void makeDraggable(final ItemNode node) {
        ((ItemDrawerEntry)node.getActor()).addListener(CursorManager.hoverHelper(CursorManager.CursorType.Hand));
        this.editor.getDragAndDrop().addSource(new DragAndDrop.Source((Actor)node.getActor()){

            @Override
            public DragAndDrop.Payload dragStart(InputEvent event, float x, float y, int pointer) {
                Predicate<Item> pred;
                CursorManager.setCursor(CursorManager.CursorType.Hand);
                if (((Item)node.getValue()).hasProperty(PropertyType.Unique) && ItemDrawer.this.editor.containsItemWhere(pred = new Predicate<Item>(){

                    @Override
                    public boolean test(Item arg0) {
                        return arg0.hasProperty(PropertyType.Unique) && arg0.getType().name.equals(((Item)node.getValue()).getType().name);
                    }
                })) {
                    return null;
                }
                ItemDrawer.this.getSelection().clear();
                DragAndDrop.Payload p = new DragAndDrop.Payload();
                p.setObject(node.getValue());
                SmallLabel l = new SmallLabel(((Item)Item.class.cast(node.getValue())).getItemName(), "default", 0.65f);
                p.setDragActor(l);
                return p;
            }

            @Override
            public void dragStop(InputEvent event, float x, float y, int pointer, @Null DragAndDrop.Payload payload, @Null DragAndDrop.Target target) {
                CursorManager.restoreDefault();
            }
        });
    }

    public ItemDrawer(LevelEditorScreen editor) {
        super(LevelEditorScreen.skin);
        this.setIndentSpacing(0.0f);
        this.setPadding(5.0f, 5.0f);
        this.editor = editor;
    }

    public class ItemNode
    extends ItemCategory {
        public ItemNode(Item item) {
            this(item, false);
        }

        public ItemNode(Item item, boolean selectable) {
            super(new ItemDrawerEntry(item));
            ItemDrawer.this.prototypes.add(item);
            this.setValue(item);
            ItemDrawer.this.makeDraggable(this);
            this.setSelectable(selectable);
            if (item.hasProperty(PropertyType.Brushable)) {
                this.setSelectable(true);
                this.brush = Optional.of(new ItemBrush(ItemDrawer.this.editor, item));
            } else if (item.hasProperty(PropertyType.TiledBrushable)) {
                this.setSelectable(true);
                this.brush = Optional.of(new TiledBrush(ItemDrawer.this.editor, item));
            }
        }
    }

    private static class ItemDrawerEntry
    extends Table {
        public ItemDrawerEntry(String categoryName) {
            this.add(new SmallLabel(categoryName));
        }

        public ItemDrawerEntry(Item item) {
            this.padLeft(0.0f);
            this.defaults().pad(5.0f).left();
            ItemSlot s = new ItemSlot(item);
            s.setTouchable(Touchable.disabled);
            this.add(s);
            SmallLabel label = new SmallLabel(item.getItemName());
            label.setTouchable(Touchable.disabled);
            this.add(label).minWidth(100.0f);
            if (item.hasProperty(PropertyType.Brushable) || item.hasProperty(PropertyType.TiledBrushable)) {
                Image brushImg = new Image(AssetManager.instance().getRegion("brush"));
                brushImg.setScaling(Scaling.contain);
                this.add(brushImg).height(25.0f).width(25.0f);
            }
            this.setTouchable(Touchable.enabled);
        }
    }

    public class ItemCategory
    extends Tree.Node<ItemNode, Item, ItemDrawerEntry> {
        Optional<Brush> brush;

        protected ItemCategory(ItemDrawerEntry entry) {
            super(entry);
            this.brush = Optional.empty();
            this.setSelectable(false);
        }

        public ItemCategory(String categoryName) {
            this(new ItemDrawerEntry(categoryName));
        }

        public Optional<Brush> getBrush() {
            return this.brush;
        }
    }
}

