/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.Poll;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editorTools.DeletionTool;
import group24.escaperoom.ui.editorTools.SelectionTool;
import java.util.Optional;

public class ItemSelectionTool
extends SelectionTool
implements Poll {
    public ItemSelectionTool(Stage uiStage, LevelEditorScreen editor) {
        super(editor);
    }

    @Override
    public Optional<SelectionTool.Selection> getSelection() {
        if (this.selection == null) {
            return Optional.empty();
        }
        if (this.selection.getItems().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.selection);
    }

    public void setItems(Array<Item> items) {
        if (this.selection == null) {
            this.selection = new SelectionTool.Selection(new Rectangle(), new Array<Item>(), this.editor);
        }
        this.selection.setItems(items);
    }

    @Override
    public void startSelection(float x, float y) {
        super.startSelection(x, y);
        this.editor.addPollable(this);
    }

    @Override
    public void endSelection() {
        this.selecting = false;
        if (this.getSelection().isEmpty()) {
            this.editor.removeOverlayDrawable(this);
        } else {
            this.selection.minimizeArea();
        }
        BackManager.addBack(() -> {
            if (this.getSelection().isEmpty()) {
                return false;
            }
            this.editor.removeOverlayDrawable(this);
            this.selection.clearSelectedItems();
            this.selection = null;
            return true;
        });
    }

    public void deleteSelected() {
        this.getSelection().ifPresent(selection -> {
            Array<Item> items = selection.getItems();
            Item[] itemsArr = new Item[items.size];
            for (int i = 0; i < items.size; ++i) {
                Item item = items.get(i);
                item.remove();
                itemsArr[i] = item;
            }
            this.editor.recordEditorAction(new DeletionTool.Deletion(this.editor, itemsArr));
            selection.clearSelectedItems();
        });
        this.editor.removeOverlayDrawable(this);
    }

    private void selectItems() {
        for (Item item : this.editor.getItemsIn(this.selection.area)) {
            item.setSelected(true);
            this.selection.addItem(item);
        }
    }

    @Override
    public String getButtonStyle() {
        return "selectButton";
    }

    @Override
    public ToolManager.ToolType getType() {
        return ToolManager.ToolType.ItemSelect;
    }

    @Override
    public boolean poll(float delta) {
        if (this.selecting) {
            this.selection.clearSelectedItems();
            this.selectItems();
            return true;
        }
        return false;
    }
}

