/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.ActionHistory;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editorTools.EditorTool;
import group24.escaperoom.ui.editorTools.SelectionTool;
import java.util.Optional;

public class MoveTool
extends EditorTool {
    Types.IntVector2 startPoint;
    Optional<MovesItems> activeTool;
    private InputListener moveListener = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            MoveTool.this.startPoint = new Types.IntVector2(x, y);
            Optional<SelectionTool.Selection> selection = MoveTool.this.editor.getSelectionTool().getSelection();
            if (selection.isPresent() && selection.get().getArea().contains(MoveTool.this.startPoint.asVector2())) {
                MoveTool.this.activeTool = Optional.of(new BulkMoveTool(selection.get()));
                return true;
            }
            Optional<Item> oTarget = MoveTool.this.editor.priorityItemAt(MoveTool.this.startPoint.x, MoveTool.this.startPoint.y);
            if (oTarget.isPresent()) {
                MoveTool.this.activeTool = Optional.of(new SoloMoveTool(oTarget.get(), MoveTool.this.editor));
                return true;
            }
            return false;
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            MoveTool.this.activeTool.ifPresent(t -> t.handleDrag(x, y));
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            MoveTool.this.activeTool.ifPresent(t -> t.handleUp(x, y));
            MoveTool.this.activeTool = Optional.empty();
        }
    };

    public MoveTool(Stage uiStage, LevelEditorScreen editor) {
        super(editor);
        this.activeTool = Optional.empty();
    }

    @Override
    public void select() {
        this.editor.addListener(this.moveListener);
        CursorManager.setCursor(CursorManager.CursorType.Move);
    }

    @Override
    public void cancel() {
        this.editor.removeListener(this.moveListener);
        this.activeTool.ifPresent(t -> t.cancel());
        this.activeTool = Optional.empty();
        CursorManager.restoreDefault();
    }

    @Override
    public String getName() {
        return "Move";
    }

    @Override
    public String getButtonStyle() {
        return "moveButton";
    }

    @Override
    public ToolManager.ToolType getType() {
        return ToolManager.ToolType.Move;
    }

    private static interface MovesItems {
        public void handleDrag(float var1, float var2);

        public void handleUp(float var1, float var2);

        public void cancel();
    }

    public static class SoloMoveTool
    implements MovesItems {
        Types.IntVector2 originalPosition;
        Types.IntVector2 finalPosition;
        LevelEditorScreen editor;
        Item target;

        public SoloMoveTool(Item target, LevelEditorScreen editor) {
            this.editor = editor;
            this.target = target;
            this.originalPosition = target.getPosition().cpy();
        }

        public Item getItem() {
            return this.target;
        }

        @Override
        public void handleDrag(float x, float y) {
            Types.IntVector2 newPos = new Types.IntVector2(x, y);
            if (newPos.equals(this.target.getPosition())) {
                return;
            }
            this.target.setAlpha(0.5f);
            this.target.remove(true);
            if (this.editor.canPlace(this.target, newPos)) {
                CursorManager.setCursor(CursorManager.CursorType.Move);
                this.editor.placeItem(this.target);
                this.target.moveTo(newPos.x, newPos.y);
                this.target.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                CursorManager.setCursor(CursorManager.CursorType.InvalidMove);
                this.target.setColor(1.0f, 0.5f, 0.5f, 0.5f);
                this.editor.placeItem(this.target);
            }
        }

        @Override
        public void handleUp(float x, float y) {
            this.finalPosition = this.target.getPosition().cpy();
            this.target.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.editor.recordEditorAction(new MoveAction());
        }

        @Override
        public void cancel() {
            this.target.moveTo(this.originalPosition.x, this.originalPosition.y);
            this.target.setAlpha(1.0f);
        }

        private class MoveAction
        implements ActionHistory.EditorAction {
            private MoveAction() {
            }

            @Override
            public void doAction() {
                SoloMoveTool.this.target.moveTo(SoloMoveTool.this.finalPosition.x, SoloMoveTool.this.finalPosition.y);
            }

            @Override
            public void undoAction() {
                SoloMoveTool.this.target.moveTo(SoloMoveTool.this.originalPosition.x, SoloMoveTool.this.originalPosition.y);
            }
        }
    }

    private class BulkMoveTool
    implements MovesItems {
        Array<MovingItem> items = new Array();
        SelectionTool.Selection selection;
        Vector2 selectionOffset;

        public BulkMoveTool(SelectionTool.Selection activeSelection) {
            this.selection = activeSelection;
            Array<Item> selection = activeSelection.getItems();
            Rectangle selectionArea = this.selection.getArea();
            this.selectionOffset = new Vector2(selectionArea.getX() - (float)MoveTool.this.startPoint.x, selectionArea.getY() - (float)MoveTool.this.startPoint.y);
            for (Item i : selection) {
                i.setAlpha(0.5f);
                this.items.add(new MovingItem(i, i.getX() - MoveTool.this.startPoint.x, i.getY() - MoveTool.this.startPoint.y));
            }
        }

        @Override
        public void handleDrag(float x, float y) {
            Vector2 newPos = new Vector2(x, y);
            for (MovingItem movingItem : this.items) {
                MoveTool.this.editor.grid.removeItem(movingItem.item);
            }
            boolean illegalMove = false;
            for (MovingItem i : this.items) {
                if (!MoveTool.this.editor.canPlace(i.item, i.newPositionFor(newPos))) {
                    CursorManager.setCursor(CursorManager.CursorType.InvalidMove);
                    i.item.setColor(1.0f, 0.5f, 0.5f, 0.5f);
                    illegalMove = true;
                    continue;
                }
                i.item.setColor(1.0f, 1.0f, 1.0f, 0.5f);
            }
            if (illegalMove) {
                for (MovingItem item : this.items) {
                    MoveTool.this.editor.grid.placeItem(item.item);
                }
                return;
            }
            CursorManager.setCursor(CursorManager.CursorType.Move);
            for (MovingItem i : this.items) {
                Types.IntVector2 newPosI = i.newPositionFor(newPos);
                i.item.moveTo(newPosI.x, newPosI.y);
                i.item.setColor(1.0f, 1.0f, 1.0f, 0.5f);
            }
            for (MovingItem item : this.items) {
                MoveTool.this.editor.grid.placeItem(item.item);
            }
            Vector2 vector2 = new Vector2(MathUtils.floor(newPos.x + this.selectionOffset.x), MathUtils.floor(newPos.y + this.selectionOffset.y));
            this.selection.getArea().setPosition(vector2.x, vector2.y);
        }

        @Override
        public void handleUp(float x, float y) {
            for (MovingItem i : this.items) {
                i.pos.finalPosition = i.item.getPosition();
                i.item.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
            MoveTool.this.editor.recordEditorAction(new BulkMoveAction(this.items));
            this.items = new Array();
        }

        @Override
        public void cancel() {
            for (MovingItem i : this.items) {
                i.returnToWhenceYouCame();
            }
        }

        class MovingItem {
            Item item;
            PositionInfo pos;
            Vector2 offsets;

            public MovingItem(Item i, float offsetX, float offsetY) {
                this.item = i;
                this.pos = new PositionInfo();
                this.offsets = new Vector2(offsetX, offsetY);
                this.pos.originalPosition = new Types.IntVector2(MathUtils.floor(i.getX()), MathUtils.floor(i.getY()));
            }

            public Types.IntVector2 newPositionFor(Vector2 point) {
                return new Types.IntVector2(MathUtils.floor(point.x + this.offsets.x), MathUtils.floor(point.y + this.offsets.y));
            }

            public void returnToWhenceYouCame() {
                this.item.moveTo(this.pos.originalPosition.x, this.pos.originalPosition.y);
                this.item.setAlpha(1.0f);
            }
        }

        class PositionInfo {
            Types.IntVector2 originalPosition;
            Types.IntVector2 finalPosition;

            PositionInfo() {
            }
        }

        private class BulkMoveAction
        implements ActionHistory.EditorAction {
            private Array<MovingItem> items;

            public BulkMoveAction(Array<MovingItem> items) {
                this.items = items;
            }

            @Override
            public void doAction() {
                for (MovingItem info : this.items) {
                    info.item.moveTo(info.pos.finalPosition.x, info.pos.finalPosition.y);
                }
            }

            @Override
            public void undoAction() {
                for (MovingItem info : this.items) {
                    info.item.moveTo(info.pos.originalPosition.x, info.pos.originalPosition.y);
                }
            }
        }
    }
}

