/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editorTools.EditorTool;

public class PanTool
extends EditorTool {
    private Vector2 lastScreenPoint;
    private InputListener panListener = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            PanTool.this.handleTouchDown();
            return true;
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            PanTool.this.handleDrag();
        }
    };

    public PanTool(LevelEditorScreen stage) {
        super(stage);
    }

    public void handleTouchDown() {
        this.lastScreenPoint = new Vector2(Gdx.input.getX(), Gdx.input.getY());
    }

    public void handleDrag() {
        Vector2 newPoint = new Vector2(Gdx.input.getX(), Gdx.input.getY());
        Vector2 p1 = this.editor.getViewport().unproject(this.lastScreenPoint);
        Vector2 p2 = this.editor.getViewport().unproject(newPoint.cpy());
        this.editor.panCamera(p1.x - p2.x, p1.y - p2.y);
        this.lastScreenPoint = newPoint;
    }

    @Override
    public void select() {
        CursorManager.setCursor(CursorManager.CursorType.Hand);
        this.editor.addListener(this.panListener);
    }

    @Override
    public void cancel() {
        CursorManager.restoreDefault();
        this.editor.removeListener(this.panListener);
    }

    @Override
    public String getName() {
        return "Pan Tool";
    }

    @Override
    public String getButtonStyle() {
        return "pan";
    }

    @Override
    public ToolManager.ToolType getType() {
        return ToolManager.ToolType.Pan;
    }
}

