/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import group24.escaperoom.data.Grid;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.objects.ObjectTypeData;
import group24.escaperoom.entities.properties.ItemProperty;
import group24.escaperoom.entities.properties.ItemPropertyValue;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.ActionHistory;
import group24.escaperoom.screens.editor.GridView;
import group24.escaperoom.screens.editor.ItemDecoration;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editor.Menu;
import group24.escaperoom.ui.editor.PropertyMenu;
import group24.escaperoom.ui.editorTools.EditorTool;
import group24.escaperoom.utils.Notifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;

public class PropertyTool
extends EditorTool {
    private static final HashSet<PropertyType> excludedProperties = new HashSet<PropertyType>(Arrays.asList(PropertyType.TiledBrushable, PropertyType.Stylable));
    State state = State.Inactive;
    Types.IntVector2 touchDown = new Types.IntVector2(-1, -1);
    Collection<ItemProperty<? extends ItemPropertyValue>> itemProperties;
    ItemProperty<? extends ItemPropertyValue> singleProperty;
    ObjectTypeData originalType;
    boolean pasting;
    private final InputListener copyPasteListener = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            if (button == 0) {
                return PropertyTool.this.handleTouchDown(x, y);
            }
            if (button == 1) {
                return PropertyTool.this.handleSelectProperties(x, y);
            }
            return false;
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            PropertyTool.this.handleDrag(x, y);
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            PropertyTool.this.pasting = false;
        }
    };

    public PropertyTool(LevelEditorScreen editor) {
        super(editor);
    }

    public boolean isPasting() {
        return this.pasting;
    }

    @Override
    public void select() {
        this.editor.addListener(this.copyPasteListener);
        CursorManager.setCursor(CursorManager.CursorType.CopyPaste);
        if (this.state != State.Inactive) {
            this.applyCopied(this.state);
        }
    }

    @Override
    public void cancel() {
        this.editor.removeListener(this.copyPasteListener);
        CursorManager.restoreDefault();
        if (this.state != State.Inactive) {
            this.editor.clearGridView();
        }
    }

    private void attemptPasteAt(float x, float y) {
        if (this.state == State.Inactive) {
            Notifier.warn("Properties not yet copied.");
            return;
        }
        Optional<Item> oTarget = this.editor.priorityItemAt((int)x, (int)y);
        if (!oTarget.isPresent()) {
            return;
        }
        Item i = oTarget.get();
        Grid.onMapCompletion.clear();
        switch (this.state) {
            case Inactive: {
                throw new IllegalStateException();
            }
            case Item: {
                if (!i.getType().equals(this.originalType)) {
                    return;
                }
                this.itemProperties.forEach(p -> {
                    if (!excludedProperties.contains((Object)p.getType())) {
                        i.addProperty(p.cloneProperty(i));
                    }
                });
                this.editor.recordEditorAction(new SetProperty(i, i.getProperties(), this.itemProperties));
                break;
            }
            case Property: {
                if (!i.hasProperty(this.singleProperty.getType())) {
                    return;
                }
                i.addProperty(this.singleProperty.cloneProperty(i));
            }
        }
        Notifier.info(String.format("Pasted properties to %s", i.getItemName()));
        Grid.onMapCompletion.forEach(f -> f.apply(this.editor.grid));
    }

    private void attemptCopyAt(float x, float y) {
        Vector2 screenCoords = this.editor.gameCoordToUI(new Vector2(x, y));
        Menu.MenuEntry entry = this.editor.collidedMenuEntry(screenCoords.x, screenCoords.y, PropertyMenu.class);
        if (entry != null && entry instanceof PropertyMenu.PropertyMenuEntry) {
            PropertyMenu.PropertyMenuEntry e = (PropertyMenu.PropertyMenuEntry)entry;
            this.singleProperty = e.getProperty();
            this.applyCopied(State.Property);
            Notifier.info(String.format("Copied %s property", e.getProperty().getDisplayName()));
            return;
        }
        Optional<Item> oTarget = this.editor.priorityItemAt((int)x, (int)y);
        if (oTarget.isPresent()) {
            Item i = oTarget.get();
            this.itemProperties = i.getProperties();
            this.originalType = i.getType();
            this.applyCopied(State.Item);
            Notifier.info(String.format("Copied properties of %s", i.getItemName()));
            return;
        }
    }

    private void applyCopied(State state) {
        this.state = state;
        this.editor.setGridView(new PasteView());
        BackManager.addBack(() -> {
            EditorTool current = this.editor.getActiveTool();
            if (current == null || current.getType() != this.getType()) {
                return false;
            }
            this.itemProperties = null;
            this.originalType = null;
            this.singleProperty = null;
            this.state = State.Inactive;
            this.editor.clearGridView();
            Notifier.info("Cleared property selection");
            return true;
        });
    }

    private boolean handleTouchDown(float x, float y) {
        this.pasting = true;
        this.touchDown.set(x, y);
        this.attemptPasteAt(x, y);
        return true;
    }

    private boolean handleSelectProperties(float x, float y) {
        this.pasting = false;
        this.attemptCopyAt(x, y);
        return true;
    }

    private void handleDrag(float x, float y) {
        if (!this.pasting || this.touchDown.equals((int)x, (int)y)) {
            return;
        }
        this.touchDown.set(x, y);
        this.attemptPasteAt(x, y);
    }

    @Override
    public String getButtonStyle() {
        return "property_cv";
    }

    @Override
    public ToolManager.ToolType getType() {
        return ToolManager.ToolType.Properties;
    }

    @Override
    public String getName() {
        return "Copy Properties";
    }

    protected static enum State {
        Inactive,
        Property,
        Item;

    }

    public static class SetProperty
    implements ActionHistory.EditorAction {
        State state;
        Item item;
        Collection<ItemProperty<? extends ItemPropertyValue>> originals;
        Collection<ItemProperty<? extends ItemPropertyValue>> replacement;
        ItemProperty<? extends ItemPropertyValue> original;
        ItemProperty<? extends ItemPropertyValue> replaced;

        public SetProperty(Item item, Collection<ItemProperty<? extends ItemPropertyValue>> originals, Collection<ItemProperty<? extends ItemPropertyValue>> replacement) {
            this.state = State.Item;
            this.item = item;
            this.originals = originals;
            this.replacement = replacement;
        }

        public SetProperty(Item item, ItemProperty<? extends ItemPropertyValue> original, ItemProperty<? extends ItemPropertyValue> replaced) {
            this.state = State.Property;
            this.item = item;
            this.original = original;
            this.replaced = replaced;
        }

        @Override
        public void doAction() {
            switch (this.state) {
                case Inactive: {
                    throw new IllegalStateException();
                }
                case Item: {
                    this.replacement.forEach(p -> this.item.addProperty((ItemProperty<? extends ItemPropertyValue>)p));
                }
                case Property: {
                    this.item.addProperty(this.replaced);
                }
            }
        }

        @Override
        public void undoAction() {
            switch (this.state) {
                case Inactive: {
                    throw new IllegalStateException();
                }
                case Item: {
                    this.originals.forEach(p -> this.item.addProperty((ItemProperty<? extends ItemPropertyValue>)p));
                }
                case Property: {
                    this.item.addProperty(this.original);
                }
            }
        }
    }

    private class PasteView
    implements GridView {
        private PasteView() {
        }

        @Override
        public ItemDecoration decorate(Item item) {
            ItemDecoration decoration = new ItemDecoration();
            boolean valid = false;
            switch (PropertyTool.this.state) {
                case Item: {
                    valid = item.getType().equals(PropertyTool.this.originalType);
                    break;
                }
                case Property: {
                    valid = item.hasProperty(PropertyTool.this.singleProperty.getType());
                    break;
                }
            }
            if (valid) {
                decoration.set(ItemDecoration.DIMMED, false);
            } else {
                decoration.set(ItemDecoration.DIMMED, true);
            }
            return decoration;
        }
    }
}

