/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.editor.ActionHistory;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editorTools.EditorTool;

public class RotationTool
extends EditorTool {
    private InputListener rotateToolListener = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            return RotationTool.this.editor.priorityItemAt((int)x, (int)y).map(item -> {
                int rotation = item.getRotation();
                item.rotateBy(90);
                if (item.getRotation() != rotation) {
                    RotationTool.this.editor.recordEditorAction(new RotationAction((Item)item));
                }
                return true;
            }).orElse(false);
        }
    };

    public RotationTool(LevelEditorScreen stage) {
        super(stage);
    }

    @Override
    public void cancel() {
        CursorManager.restoreDefault();
        this.editor.removeListener(this.rotateToolListener);
    }

    @Override
    public void select() {
        CursorManager.setCursor(CursorManager.CursorType.Rotate);
        this.editor.addListener(this.rotateToolListener);
    }

    @Override
    public String getButtonStyle() {
        return "rotateButton";
    }

    @Override
    public ToolManager.ToolType getType() {
        return ToolManager.ToolType.Rotation;
    }

    @Override
    public String getName() {
        return "Rotate";
    }

    public static class RotationAction
    implements ActionHistory.EditorAction {
        Item target;

        public RotationAction(Item obj) {
            this.target = obj;
        }

        @Override
        public void doAction() {
            this.target.rotateBy(90);
        }

        @Override
        public void undoAction() {
            this.target.rotateBy(-90);
        }
    }
}

