/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.utils.Array;
import group24.escaperoom.AssetManager;
import group24.escaperoom.data.Drawable;
import group24.escaperoom.entities.Item;
import group24.escaperoom.screens.CursorManager;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.screens.editor.ToolManager;
import group24.escaperoom.ui.editorTools.EditorTool;
import java.util.Optional;
import java.util.function.Function;

public abstract class SelectionTool
extends EditorTool
implements Drawable {
    private NinePatch texture;
    protected Selection selection;
    protected boolean selecting;
    private InputListener selectListener = new InputListener(){

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            if (SelectionTool.this.editor.collidesMenu(x, y)) {
                SelectionTool.this.cancel();
                return false;
            }
            SelectionTool.this.startSelection(x, y);
            return true;
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            SelectionTool.this.selection.setEnd(new Vector2(x, y));
            SelectionTool.this.selection.updateArea();
            SelectionTool.this.editor.getUI().getHints().coordHints.update(SelectionTool.this.selection.area);
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            SelectionTool.this.endSelection();
        }
    };

    public SelectionTool(LevelEditorScreen stage) {
        super(stage);
        AssetManager.instance().load("textures/selection_bkg.9.png", Texture.class);
        AssetManager.instance().finishLoadingAsset("textures/selection_bkg.9.png");
        Texture bkg = AssetManager.instance().get("textures/selection_bkg.9.png", Texture.class);
        this.texture = new NinePatch(bkg, 6, 6, 6, 6);
    }

    public void startSelection(float x, float y) {
        this.selecting = true;
        if (this.selection == null) {
            this.selection = new Selection(new Rectangle(), new Array<Item>(), this.editor);
        } else {
            this.selection.area.set(MathUtils.floor(x), MathUtils.floor(y), 1.0f, 1.0f);
        }
        this.editor.addOverlayDrawable(this);
        this.selection.setStart(new Vector2(x, y));
    }

    public Optional<Selection> getSelection() {
        return Optional.of(this.selection);
    }

    public void endSelection() {
        this.selecting = false;
        this.editor.removeOverlayDrawable(this);
    }

    @Override
    public void cancel() {
        CursorManager.restoreDefault();
        this.editor.removeListener(this.selectListener);
    }

    @Override
    public String getName() {
        return "Select Tool";
    }

    @Override
    public void select() {
        CursorManager.setCursor(CursorManager.CursorType.Select);
        this.editor.addListener(this.selectListener);
    }

    public Optional<Rectangle> getSelectionArea() {
        if (this.selection == null) {
            return Optional.empty();
        }
        return Optional.of(this.selection.getArea());
    }

    @Override
    public ToolManager.ToolType getType() {
        return ToolManager.ToolType.Selection;
    }

    @Override
    public int renderPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void draw(Batch batch) {
        this.texture.draw(batch, this.selection.area.getX(), this.selection.area.getY(), 0.0f, 0.0f, this.selection.area.width * 16.0f, this.selection.area.height * 16.0f, 0.0625f, 0.0625f, 0.0f);
    }

    @Override
    public Vector2 position() {
        return new Vector2(0.0f, 0.0f);
    }

    @Override
    public int getTileDepth() {
        return 0;
    }

    public static class Selection {
        protected Rectangle area = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        protected Array<Item> selectedItems = new Array();
        Vector2 start = new Vector2();
        Vector2 end = new Vector2();
        protected MapScreen screen = null;

        public Selection(Rectangle area, Array<Item> selectedItems, MapScreen screen) {
            this.area = area;
            this.selectedItems = selectedItems;
            this.screen = screen;
        }

        public void minimizeArea() {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = -1;
            int maxY = -1;
            for (Item i : this.selectedItems) {
                minX = i.getX() < minX ? i.getX() : minX;
                minY = i.getY() < minY ? i.getY() : minY;
                int upperX = i.getX() + i.getWidth();
                int upperY = i.getY() + i.getHeight();
                maxX = upperX > maxX ? upperX : maxX;
                maxY = upperY > maxY ? upperY : maxY;
            }
            this.area.set(minX, minY, maxX - minX, maxY - minY);
        }

        protected void addItem(Item item) {
            this.selectedItems.add(item);
        }

        public void setStart(Vector2 vec) {
            this.start.set(vec);
        }

        public void setEnd(Vector2 vec) {
            this.end.set(vec);
        }

        public Rectangle getArea() {
            return this.area;
        }

        public Array<Item> getItems() {
            return this.selectedItems;
        }

        public void setItems(Array<Item> items) {
            this.selectedItems.forEach(i -> i.setSelected(false));
            this.selectedItems = items;
            this.selectedItems.forEach(i -> i.setSelected(true));
            this.minimizeArea();
        }

        public void clearSelectedItems() {
            for (Item item : this.selectedItems) {
                item.setSelected(false);
            }
            this.selectedItems.clear();
        }

        public void updateArea() {
            float x = Math.min(this.start.x, this.end.x);
            float y = Math.min(this.start.y, this.end.y);
            float width = Math.abs(this.end.x - this.start.x);
            float height = Math.abs(this.end.y - this.start.y);
            Vector2 snapOrigin = this.snap(new Vector2(x, y), SnapMethod.Floor);
            Vector2 snapEnd = this.snap(new Vector2(x + width, y + height), SnapMethod.Ceil);
            this.area.set(MathUtils.round(snapOrigin.x), MathUtils.round(snapOrigin.y), MathUtils.round(snapEnd.x - snapOrigin.x), MathUtils.round(snapEnd.y - snapOrigin.y));
        }

        public void setNewArea(Rectangle rectangle) {
            this.setStart(new Vector2(rectangle.getX(), rectangle.getY()));
            this.setEnd(new Vector2(rectangle.getX() + rectangle.getWidth(), rectangle.getY() + rectangle.getHeight()));
            this.updateArea();
        }

        private Vector2 snap(Vector2 gameCoords, SnapMethod snap) {
            return new Vector2(((Integer)snap.method.apply(Float.valueOf(gameCoords.x))).intValue(), ((Integer)snap.method.apply(Float.valueOf(gameCoords.y))).intValue());
        }

        private static enum SnapMethod {
            Ceil(f -> MathUtils.ceil(f.floatValue())),
            Floor(f -> MathUtils.floor(f.floatValue()));

            private Function<Float, Integer> method;

            private SnapMethod(Function<Float, Integer> method) {
                this.method = method;
            }
        }
    }
}

