/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.editorTools;

import com.badlogic.gdx.math.Vector2;
import group24.escaperoom.data.Types;
import group24.escaperoom.entities.Item;
import group24.escaperoom.entities.properties.PropertyType;
import group24.escaperoom.entities.properties.TiledBrushable;
import group24.escaperoom.screens.LevelEditorScreen;
import group24.escaperoom.screens.MapScreen;
import group24.escaperoom.ui.editorTools.DeletionTool;
import group24.escaperoom.ui.editorTools.ItemBrush;
import java.util.Optional;

public class TiledBrush
extends ItemBrush {
    Vector2 lastTouchDown = new Vector2(0.0f, 0.0f);

    @Override
    public boolean handleTouchDown(float x, float y) {
        Types.IntVector2 newPos = new Types.IntVector2((int)x, (int)y);
        this.lastTouchDown = newPos.asVector2();
        Optional<Item> matchingItem = TiledBrush.matchingItemAt(newPos, newPos, this.editor, this.item);
        if (matchingItem.isPresent()) {
            this.path.add(newPos);
            return true;
        }
        Item newItem = this.item.clone();
        if (this.editor.canPlace(newItem, newPos)) {
            this.placeAt(newItem, newPos);
            TiledBrush.updateTiles(newPos, this.editor, this.item, true);
            return true;
        }
        return false;
    }

    @Override
    public void handleTouchUp() {
        this.path.clear();
    }

    @Override
    public void handleDrag(float x, float y) {
        Types.IntVector2 newPos = new Types.IntVector2((int)x, (int)y);
        if (newPos.equals(this.path.get(this.path.size - 1))) {
            return;
        }
        if (this.path.size >= 2 && newPos.equals(this.path.get(this.path.size - 2))) {
            this.placedItemAt((Types.IntVector2)this.path.get(this.path.size - 1)).ifPresent(i -> {
                i.remove(false);
                this.editor.recordEditorAction(new DeletionTool.Deletion(this.editor, (Item)i));
            });
            this.path.pop();
            return;
        }
        Optional<Item> matchingItem = TiledBrush.matchingItemAt(newPos, newPos, this.editor, this.item);
        if (matchingItem.isPresent()) {
            this.path.add(newPos);
            this.addedIDs.add(matchingItem.get().getID());
            return;
        }
        Item newItem = this.item.clone();
        if (this.editor.canPlace(newItem, newPos)) {
            this.placeAt(newItem, newPos);
            TiledBrush.updateTiles(newPos, this.editor, this.item, true);
        }
    }

    public TiledBrush(LevelEditorScreen editor, Item item) {
        super(editor, item);
    }

    public static void updateSurroundingTiles(Types.IntVector2 origin, MapScreen map, Item item) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                origin.add(dx, dy);
                TiledBrush.matchingItemAt(origin, origin, map, item).ifPresent(matching -> matching.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tilable -> TiledBrush.updateTiles(origin, map, item, false)));
                origin.sub(dx, dy);
            }
        }
    }

    public static void updateTiles(Types.IntVector2 position, MapScreen map, Item item, boolean recurse) {
        TiledBrush.matchingItemAt(position, position, map, item).ifPresent(matchingItem -> {
            switch (TiledBrush.getAdjancencies(position, map, item, recurse)) {
                case 11: 
                case 15: 
                case 43: 
                case 47: 
                case 139: 
                case 143: 
                case 171: 
                case 175: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_TL));
                    break;
                }
                case 31: 
                case 63: 
                case 159: 
                case 191: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_T));
                    break;
                }
                case 22: 
                case 23: 
                case 54: 
                case 55: 
                case 150: 
                case 151: 
                case 182: 
                case 183: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_TR));
                    break;
                }
                case 107: 
                case 111: 
                case 235: 
                case 239: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_L));
                    break;
                }
                case 255: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CENTER));
                    break;
                }
                case 214: 
                case 215: 
                case 246: 
                case 247: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_R));
                    break;
                }
                case 104: 
                case 105: 
                case 108: 
                case 109: 
                case 232: 
                case 233: 
                case 236: 
                case 237: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_BL));
                    break;
                }
                case 248: 
                case 249: 
                case 252: 
                case 253: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_B));
                    break;
                }
                case 208: 
                case 209: 
                case 212: 
                case 213: 
                case 240: 
                case 241: 
                case 244: 
                case 245: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_BR));
                    break;
                }
                case 127: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_NO_TL));
                    break;
                }
                case 223: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_NO_TR));
                    break;
                }
                case 251: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_NO_BL));
                    break;
                }
                case 254: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BLOCK_NO_BR));
                    break;
                }
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 40: 
                case 41: 
                case 44: 
                case 45: 
                case 136: 
                case 140: 
                case 141: 
                case 168: 
                case 169: 
                case 172: 
                case 173: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.LINE_CAP_L));
                    break;
                }
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 48: 
                case 49: 
                case 52: 
                case 53: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 176: 
                case 177: 
                case 180: 
                case 181: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.LINE_CAP_R));
                    break;
                }
                case 24: 
                case 25: 
                case 28: 
                case 29: 
                case 56: 
                case 57: 
                case 60: 
                case 61: 
                case 152: 
                case 153: 
                case 156: 
                case 157: 
                case 184: 
                case 185: 
                case 188: 
                case 189: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.LINE_HORI));
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 34: 
                case 35: 
                case 38: 
                case 39: 
                case 130: 
                case 131: 
                case 134: 
                case 135: 
                case 162: 
                case 163: 
                case 166: 
                case 167: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.LINE_CAP_T));
                    break;
                }
                case 64: 
                case 65: 
                case 68: 
                case 69: 
                case 96: 
                case 97: 
                case 100: 
                case 101: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 224: 
                case 225: 
                case 228: 
                case 229: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.LINE_CAP_B));
                    break;
                }
                case 66: 
                case 67: 
                case 70: 
                case 71: 
                case 98: 
                case 99: 
                case 102: 
                case 103: 
                case 194: 
                case 195: 
                case 198: 
                case 199: 
                case 226: 
                case 227: 
                case 230: 
                case 231: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.LINE_VERT));
                    break;
                }
                case 82: 
                case 83: 
                case 114: 
                case 115: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.T_L));
                    break;
                }
                case 74: 
                case 78: 
                case 202: 
                case 206: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.T_R));
                    break;
                }
                case 88: 
                case 89: 
                case 92: 
                case 93: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.T_T));
                    break;
                }
                case 26: 
                case 58: 
                case 154: 
                case 186: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.T_B));
                    break;
                }
                case 90: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.PLUS));
                    break;
                }
                case 72: 
                case 73: 
                case 76: 
                case 77: 
                case 200: 
                case 201: 
                case 204: 
                case 205: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_BL));
                    break;
                }
                case 10: 
                case 14: 
                case 42: 
                case 46: 
                case 138: 
                case 142: 
                case 170: 
                case 174: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_TL));
                    break;
                }
                case 18: 
                case 19: 
                case 50: 
                case 51: 
                case 146: 
                case 147: 
                case 178: 
                case 179: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_TR));
                    break;
                }
                case 80: 
                case 81: 
                case 84: 
                case 85: 
                case 112: 
                case 113: 
                case 116: 
                case 117: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_BR));
                    break;
                }
                case 210: 
                case 211: 
                case 242: 
                case 243: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.RIGHT_CORNER_BL));
                    break;
                }
                case 106: 
                case 110: 
                case 234: 
                case 238: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.LEFT_CORNER_BR));
                    break;
                }
                case 120: 
                case 121: 
                case 124: 
                case 125: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BOT_CORNER_TL));
                    break;
                }
                case 27: 
                case 59: 
                case 155: 
                case 187: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.TOP_CORNER_BL));
                    break;
                }
                case 75: 
                case 79: 
                case 203: 
                case 207: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.LEFT_CORNER_TR));
                    break;
                }
                case 86: 
                case 87: 
                case 118: 
                case 119: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.RIGHT_CORNER_TL));
                    break;
                }
                case 30: 
                case 62: 
                case 158: 
                case 190: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.TOP_CORNER_BR));
                    break;
                }
                case 216: 
                case 217: 
                case 220: 
                case 221: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.BOT_CORNER_TR));
                    break;
                }
                case 218: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_NOT_TL));
                    break;
                }
                case 122: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_NOT_TR));
                    break;
                }
                case 91: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_NOT_BR));
                    break;
                }
                case 94: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_NOT_BL));
                    break;
                }
                case 250: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_DB_B));
                    break;
                }
                case 123: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_DB_L));
                    break;
                }
                case 222: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_DB_R));
                    break;
                }
                case 95: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_DB_T));
                    break;
                }
                case 126: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_DIAG_BR));
                    break;
                }
                case 219: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CORNER_DIAG_TR));
                    break;
                }
                default: {
                    matchingItem.getProperty(PropertyType.TiledBrushable, TiledBrushable.class).ifPresent(tp -> tp.setOrientation(TiledBrushable.TileType.CENTER));
                }
            }
        });
    }

    public static int getAdjancencies(Types.IntVector2 position, MapScreen screen, Item item, boolean recurse) {
        int adjancencies = 0;
        int checked = 0;
        for (int yoff = 1; yoff >= -1; --yoff) {
            for (int xoff = -1; xoff <= 1; ++xoff) {
                if (xoff == 0 && yoff == 0) continue;
                Types.IntVector2 pos = position.cpy();
                pos.x += xoff;
                pos.y += yoff;
                if (TiledBrush.matchingItemAt(pos, position, screen, item).isPresent()) {
                    adjancencies |= 1 << 7 - checked;
                }
                ++checked;
                if (!recurse) continue;
                TiledBrush.updateTiles(pos, screen, item, false);
            }
        }
        return adjancencies;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.path.clear();
    }

    @Override
    public String getName() {
        return "TiledBrush for " + this.item.getItemName();
    }

    @Override
    public Optional<Item> draw(int x, int y) {
        Types.IntVector2 newPos = new Types.IntVector2(x, y);
        Item newItem = this.item.clone();
        if (this.editor.canPlace(newItem, newPos)) {
            newItem.setPosition(newPos);
            this.editor.placeItem(newItem);
            TiledBrush.updateTiles(newPos, this.editor, this.item, true);
            return Optional.of(newItem);
        }
        return Optional.empty();
    }
}

