/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.widgets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import group24.escaperoom.screens.AbstractScreen;

public class CollapsibleSection
extends Tree<AnyNode, Void> {
    private Window findWindowParent() {
        for (Group a = this; a != null; a = a.getParent()) {
            if (!(a instanceof Window)) continue;
            return (Window)a;
        }
        return null;
    }

    public CollapsibleSection(Label label, Actor contents) {
        super(AbstractScreen.skin);
        this.setIndentSpacing(0.0f);
        this.setYSpacing(10.0f);
        AnyNode root = new AnyNode(label);
        root.add(new AnyNode(contents));
        this.add(root);
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                CollapsibleSection.this.invalidateHierarchy();
                Window w = CollapsibleSection.this.findWindowParent();
                if (w != null) {
                    w.pack();
                    w.setPosition(w.getStage().getWidth() / 2.0f, w.getStage().getHeight() / 2.0f, 1);
                }
            }
        });
    }

    class AnyNode
    extends Tree.Node<AnyNode, Actor, Actor> {
        AnyNode(Actor a) {
            this.setActor(a);
            this.setSelectable(false);
        }
    }
}

