/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.ui.widgets;

import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import group24.escaperoom.control.ControlsManager;
import group24.escaperoom.screens.AbstractScreen;
import group24.escaperoom.screens.BackManager;
import group24.escaperoom.utils.Notifier;

public class G24TextInput
extends TextArea {
    private G24InputListener inputListener = new G24InputListener();
    private G24FocusListener focusListener = new G24FocusListener();
    boolean allowMultiLine;
    OnEnter onEnter;
    Filter filter;
    String filterInvalidMsg;

    public void enableAutoFocusTraversal() {
        this.removeListener(this.inputListener);
        TextArea.TextAreaListener traversingListener = new TextArea.TextAreaListener(){

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                boolean result = G24TextInput.this.inputListener.keyTyped(event, character);
                if (G24TextInput.this.getText().trim().length() + 1 >= G24TextInput.this.getMaxLength()) {
                    G24TextInput.this.next(false);
                }
                return result;
            }
        };
        this.addListener(traversingListener);
    }

    public G24TextInput() {
        this("", AbstractScreen.skin);
    }

    public G24TextInput(String text) {
        this(text, AbstractScreen.skin);
    }

    public G24TextInput(String text, Skin skin) {
        super(text, skin);
        this.getStyle().font.getData().setScale(0.65f);
        this.setMultiline(false);
        this.setOnEnter(() -> {});
        this.setFilter(c -> true);
        this.setTextFieldFilter(new TextField.TextFieldFilter(){

            @Override
            public boolean acceptChar(TextField textField, char c) {
                if (!G24TextInput.this.filter.isValid(c)) {
                    if (G24TextInput.this.filterInvalidMsg != null) {
                        Notifier.info(G24TextInput.this.filterInvalidMsg);
                    }
                    return false;
                }
                return true;
            }
        });
        for (EventListener l : this.getListeners()) {
            this.removeListener(l);
        }
        this.addListener(this.inputListener);
        this.addListener(this.focusListener);
    }

    public void setMultiline(boolean multiline) {
        this.allowMultiLine = multiline;
        if (!multiline) {
            this.setPrefRows(1.0f);
        }
    }

    public void setOnEnter(OnEnter action) {
        this.onEnter = action;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        this.filterInvalidMsg = null;
    }

    public void setFilter(Filter filter, String invalidMsg) {
        this.filter = filter;
        this.filterInvalidMsg = invalidMsg;
    }

    public void setAlphanumeric() {
        this.setFilter(c -> Character.isAlphabetic(c) || Character.isDigit(c));
    }

    public void setAlphanumericWithWhitespace() {
        this.setFilter(c -> Character.isAlphabetic(c) || Character.isDigit(c) || Character.isWhitespace(c));
    }

    private class G24InputListener
    extends TextArea.TextAreaListener {
        private G24InputListener() {
            super(G24TextInput.this);
        }

        @Override
        public boolean keyTyped(InputEvent event, char character) {
            if (!(G24TextInput.this.allowMultiLine || character != '\r' && character != '\n')) {
                G24TextInput.this.onEnter.perform();
                return true;
            }
            return super.keyTyped(event, character);
        }
    }

    private class G24FocusListener
    extends FocusListener {
        private G24FocusListener() {
        }

        @Override
        public boolean handle(Event event) {
            if (!(event instanceof FocusListener.FocusEvent)) {
                return false;
            }
            FocusListener.FocusEvent e = (FocusListener.FocusEvent)event;
            if (e.isFocused()) {
                ControlsManager.setKeyboardEnabled(false);
                BackManager.addBack(() -> {
                    boolean isFocused;
                    if (G24TextInput.this.getStage() == null) {
                        return false;
                    }
                    boolean bl = isFocused = G24TextInput.this.getStage().getKeyboardFocus() == G24TextInput.this;
                    if (!isFocused) {
                        return false;
                    }
                    G24TextInput.this.getStage().setKeyboardFocus(G24TextInput.this.getParent());
                    return true;
                });
            } else {
                ControlsManager.setKeyboardEnabled(true);
            }
            return true;
        }
    }

    public static interface OnEnter {
        public void perform();
    }

    public static interface Filter {
        public boolean isValid(char var1);
    }
}

