/*
 * Decompiled with CFR 0.152.
 */
package group24.escaperoom.utils;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileUtils {
    static Logger log = Logger.getLogger(FileUtils.class.getName());

    public static boolean tryCreateFolder(File dir) {
        if (!dir.exists()) {
            boolean created;
            try {
                created = dir.mkdir();
            }
            catch (Exception e) {
                log.warning("Unable to create dir " + dir.getAbsolutePath());
                e.printStackTrace();
                created = false;
            }
            if (!created) {
                return false;
            }
        }
        return true;
    }

    public static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                FileUtils.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public static boolean copyDirectory(Path src, Path dest) {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> FileUtils.copy(source, dest.resolve(src.relativize((Path)source))));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getAppDataDir() {
        File dir;
        String baseDir;
        String appFolder = "escaperoom";
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            baseDir = System.getenv("APPDATA");
            if (baseDir == null) {
                baseDir = System.getenv("LOCALAPPDATA");
            }
            if (baseDir == null) {
                baseDir = System.getProperty("user.home");
            }
        } else {
            String xdgDataHome;
            baseDir = os.contains("mac") ? System.getProperty("user.home") + "/Library/Application Support" : ((xdgDataHome = System.getenv("XDG_DATA_HOME")) != null && !xdgDataHome.isBlank() ? xdgDataHome : System.getProperty("user.home") + "/.local/share");
        }
        if (!(dir = new File(baseDir, appFolder)).exists()) {
            dir.mkdirs();
        }
        return dir.getAbsolutePath();
    }

    public static List<String> getFolders(String dir) {
        return Stream.of(new File(dir).listFiles()).filter(file -> file.isDirectory()).map(File::getName).collect(Collectors.toList());
    }

    public static List<String> getFiles(String dir) {
        return Stream.of(new File(dir).listFiles()).filter(file -> !file.isDirectory()).map(File::getName).collect(Collectors.toList());
    }
}

